@extends('layouts.print_a4')

@section('title', 'سند قبض - ' . $invoice->customer->name)
@section('doc_title', 'سند قبض (Receipt Voucher)')

@section('content')
    <div class="doc-meta">
        <div>رقم السند:
            <strong>{{ $transaction->ref_no ?: 'RCP-' . str_pad($transaction->id, 5, '0', STR_PAD_LEFT) }}</strong></div>
        <div>التاريخ: <strong>{{ $transaction->date->format('Y-m-d') }}</strong></div>
    </div>

    <div style="margin: 20px 0; font-size: 18px; line-height: 2;">
        استلمنا من السيد/ <strong>{{ $invoice->customer->name }}</strong>
        <br>
        مبلغ وقدره: <strong>{{ number_format($transaction->amount, 2) }} ج.م</strong>
        <br>
        وذلك مقابل: <strong>دفعة من فاتورة رقم #{{ $invoice->code }}</strong>
        <br>
        طريقة الدفع: <strong>نقداً</strong>
        <br>
        أودع في: <strong>{{ $transaction->treasury->name }}</strong>
    </div>

    <div class="totals-section"
        style="width: 100%; border: 2px solid #000; padding: 10px; text-align: center; font-size: 20px;">
        إجمالي المبلغ المستلم: <strong>{{ number_format($transaction->amount, 2) }} جنيه مصري فقط لا غير</strong>
    </div>

    <div style="margin-top: 30px;">
        <table style="width: 100%; border: 1px solid #ddd; padding: 10px;">
            <tr>
                <td>إجمالي الفاتورة: {{ number_format($invoice->total, 2) }}</td>
                <td>المدفوع سابقاً: {{ number_format($invoice->paid_amount - $transaction->amount, 2) }}</td>
                <td style="font-weight: bold;">المتبقي: {{ number_format($invoice->total - $invoice->paid_amount, 2) }}</td>
            </tr>
        </table>
    </div>

    <div class="signature-section">
        <div class="signature-box">
            توقيع المستلم (المحاسب)
            <div class="signature-line"></div>
        </div>
        <div class="signature-box">
            الختم
            <div style="height: 60px; border: 1px dashed #ccc; margin-top: 10px;"></div>
        </div>
    </div>
@endsection