@extends('layouts.app')

@section('content')
<div class="row mb-4">
    <div class="col-12 col-md-6">
        <h2 class="fw-light">فاتورة #{{ $invoice->code }}</h2>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('لوحة التحكم') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('accounting.invoices.index') }}">{{ __('الفواتير') }}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $invoice->code }}</li>
            </ol>
        </nav>
    </div>
    <div class="col-12 col-md-6 text-md-end">
        @if($invoice->status != 'paid' && $invoice->status != 'cancelled')
        <button type="button" class="btn btn-success me-2" data-bs-toggle="modal" data-bs-target="#paymentModal">
            <i class="fas fa-money-bill-wave me-2"></i>إضافة دفعة
        </button>
        @endif
        <a href="{{ route('accounting.invoices.print', $invoice) }}" target="_blank" class="btn btn-outline-light me-2">
            <i class="fas fa-print me-2"></i>طباعة / PDF
        </a>
        @if($invoice->status != 'cancelled' && $invoice->paid_amount == 0)
        <form action="{{ route('accounting.invoices.cancel', $invoice) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد أنك تريد إلغاء هذه الفاتورة؟')">
            @csrf
            <button type="submit" class="btn btn-outline-danger me-2">
                <i class="fas fa-times me-2"></i>إلغاء
            </button>
        </form>
        @endif
        <form action="{{ route('accounting.invoices.whatsapp', $invoice) }}" method="POST" class="d-inline">
            @csrf
            <button type="submit" class="btn btn-success">
                <i class="fab fa-whatsapp me-2"></i>إرسال تحقق
            </button>
        </form>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <!-- Invoice Content -->
        <div class="card mb-4 border-top border-4 border-primary">
            <div class="card-body p-5">
                <!-- Header -->
                <div class="row mb-5">
                    <div class="col-6">
                        <h3 class="fw-bold text-primary">{{ \App\Models\Setting::getValue('general', 'company_name', 'SmartOneGroup') }}</h3>
                        <p class="text-muted mb-0">{{ \App\Models\Setting::getValue('general', 'company_address', 'Building No 12, Tech Street') }}</p>
                        <p class="text-muted mb-0">{{ \App\Models\Setting::getValue('general', 'company_phone', 'Cairo, Egypt') }}</p>
                        <p class="text-muted">السجل الضريبي: {{ \App\Models\Setting::getValue('general', 'company_tax_id', '123-456-789') }}</p>
                    </div>
                    <div class="col-6 text-end">
                        <h4 class="mb-1">فاتورة</h4>
                        <h5 class="fw-bold mb-3">{{ $invoice->code }}</h5>
                        <p class="mb-0">التاريخ: <strong>{{ $invoice->date->format('Y-m-d') }}</strong></p>
                        @if($invoice->due_date)
                        <p class="mb-0">تاريخ الاستحقاق: <strong>{{ $invoice->due_date->format('Y-m-d') }}</strong></p>
                        @endif
                        <div class="mt-2">
                            @switch($invoice->status)
                                @case('paid')
                                    <span class="badge bg-success fs-6">مدفوعة</span>
                                    @break
                                @case('partial')
                                    <span class="badge bg-info text-dark fs-6">جزئي</span>
                                    @break
                                @case('draft')
                                    <span class="badge bg-secondary fs-6">مسودة</span>
                                    @break
                                @case('sent')
                                    <span class="badge bg-primary fs-6">مرسلة</span>
                                    @break
                            @endswitch
                        </div>
                    </div>
                </div>

                <!-- Client Info -->
                <div class="row mb-5">
                    <div class="col-12">
                        <p class="text-muted text-uppercase small mb-2">فاتورة إلى</p>
                        <h5 class="fw-bold">{{ $invoice->customer->name }}</h5>
                        <p class="mb-0">{{ $invoice->customer->company }}</p>
                        <p class="mb-0">{{ $invoice->customer->address }}</p>
                        <p class="mb-0">{{ $invoice->customer->phone }}</p>
                    </div>
                </div>

                <!-- Items -->
                <div class="table-responsive mb-4">
                    <table class="table table-striped">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>الوصف</th>
                                <th class="text-center">الكمية</th>
                                <th class="text-end">سعر الوحدة</th>
                                <th class="text-end">الإجمالي</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice->items as $index => $item)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>
                                    {{ $item->description }}
                                    @if($item->unit)
                                        <small class="text-muted ms-1">({{ $item->unit->short_name }})</small>
                                    @endif
                                    @if($item->serial_key)
                                        <div class="mt-1"><small class="text-info"><i class="fas fa-key me-1"></i>Serial: <code>{{ $item->serial_key }}</code></small></div>
                                    @endif
                                    @if($item->start_date && $item->end_date)
                                         <div class="mt-1 small text-muted">
                                            <i class="far fa-calendar-alt me-1"></i>
                                            {{ __('الفترة:') }} {{ $item->start_date->format('Y-m-d') }} - {{ $item->end_date->format('Y-m-d') }}
                                        </div>
                                    @endif
                                </td>
                                <td class="text-center">{{ $item->quantity + 0 }}</td>
                                <td class="text-end">{{ number_format($item->unit_price, 2) }}</td>
                                <td class="text-end">{{ number_format($item->total, 2) }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Totals -->
                <div class="row justify-content-end">
                    <div class="col-md-5">
                        <table class="table table-sm table-borderless">
                            <tr>
                                <td>المجموع الفرعي:</td>
                                <td class="text-end fw-bold">{{ number_format($invoice->subtotal, 2) }}</td>
                            </tr>
                            <tr>
                                <td>ضريبة القيمة المضافة ({{ $invoice->tax_percent }}%):</td>
                                <td class="text-end fw-bold">{{ number_format($invoice->tax_amount, 2) }}</td>
                            </tr>
                            <tr class="border-top border-secondary">
                                <td class="fs-5">الإجمالي:</td>
                                <td class="text-end fs-5 fw-bold text-primary">{{ number_format($invoice->total, 2) }}</td>
                            </tr>
                            <tr>
                                <td>المبلغ المدفوع:</td>
                                <td class="text-end text-success fw-bold">- {{ number_format($invoice->paid_amount, 2) }}</td>
                            </tr>
                            <tr class="border-top border-secondary">
                                <td class="fw-bold">المبلغ المستحق:</td>
                                <td class="text-end fw-bold text-danger">{{ number_format($invoice->total - $invoice->paid_amount, 2) }}</td>
                            </tr>
                        </table>
                    </div>
                </div>

                @if($invoice->notes)
                <div class="mt-4 p-3 bg-dark rounded border border-secondary">
                    <p class="fw-bold mb-1">ملاحظات:</p>
                    <p class="mb-0 small text-muted">{{ $invoice->notes }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        @if($invoice->sales_person_id)
        <!-- Sales Commission -->
        <div class="card mb-4 border-start border-4 border-info">
            <div class="card-header border-secondary">
                <h5 class="mb-0">عمولة المبيعات</h5>
            </div>
            <div class="card-body">
                <div class="d-flex justify-content-between mb-2">
                    <span class="text-muted">مندوب المبيعات:</span>
                    <a href="{{ route('accounting.sales-people.show', $invoice->sales_person_id) }}" class="fw-bold">{{ $invoice->salesPerson->name }}</a>
                </div>
                <div class="d-flex justify-content-between mb-0">
                    <span class="text-muted">قيمة العمولة:</span>
                    <span class="fw-bold text-info">{{ number_format($invoice->commission_amount, 2) }} EGP</span>
                </div>
            </div>
        </div>
        @endif

        <!-- Payments History -->
        <div class="card mb-4">
            <div class="card-header border-secondary">
                <h5 class="mb-0">سجل الدفعات</h5>
            </div>
            <div class="card-body p-0">
                <table class="table table-hover mb-0 font-sm">
                    <thead>
                        <tr>
                            <th>التاريخ</th>
                            <th>المبلغ</th>
                            <th>الطريقة</th>
                            <th class="text-end">طباعة</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($invoice->transactions as $transaction)
                        <tr>
                            <td>{{ $transaction->date->format('Y-m-d') }}</td>
                            <td class="text-success fw-bold">{{ number_format($transaction->amount, 2) }}</td>
                            <td>{{ $transaction->treasury->name }}</td>
                            <td class="text-end">
                                <a href="{{ route('accounting.invoices.payments.print', [$invoice, $transaction]) }}" target="_blank" class="text-info">
                                    <i class="fas fa-print"></i>
                                </a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="3" class="text-center py-3 text-muted">لا توجد دفعات مسجلة.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="{{ route('accounting.invoices.payment', $invoice) }}" method="POST">
            @csrf
            <div class="modal-content bg-dark">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title">تسجيل دفعة</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">تاريخ الدفع</label>
                        <input type="date" name="date" class="form-control bg-black text-white border-secondary" value="{{ date('Y-m-d') }}" required>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">مبلغ الدفع (عملة الفاتورة)</label>
                            <div class="input-group">
                                <span class="input-group-text bg-secondary border-secondary text-white">{{ $invoice->currency ? $invoice->currency->code : 'EGP' }}</span>
                                <input type="number" name="amount" class="form-control bg-black text-white border-secondary" step="0.01" value="{{ number_format($invoice->total - $invoice->paid_amount, 2, '.', '') }}">
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">سعر الصرف للدفع</label>
                             <input type="number" name="exchange_rate" id="paymentExchangeRate" class="form-control bg-black text-white border-secondary" step="0.000001" value="1.000000">
                             <div class="form-text text-muted">سعر الصرف لعملة الخزنة</div>
                        </div>
                    </div>
                    <div class="row">
                         <div class="col-md-12 mb-3">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">الدفع من المحفظة</label>
                            <div class="input-group">
                                <span class="input-group-text bg-secondary border-secondary text-white">EGP</span>
                                <input type="number" name="wallet_amount" class="form-control bg-black text-white border-secondary" step="0.01" value="0.00" max="{{ $invoice->customer->balance }}">
                            </div>
                            <small class="text-{{ $invoice->customer->balance >= 0 ? 'success' : 'danger' }}">المتاح: {{ number_format($invoice->customer->balance, 2) }}</small>
                        </div>
                    </div>

                    @if($invoice->customer->loyalty_enabled && $invoice->customer->loyalty_points > 0)
                    <div class="mb-3 p-3 bg-secondary bg-opacity-10 rounded border border-secondary">
                        <label class="form-label text-warning"><i class="fas fa-star me-1"></i>استبدال نقاط الولاء</label>
                        <div class="d-flex justify-content-between mb-2">
                            <small>النقاط المتاحة:</small>
                            <strong class="text-warning">{{ number_format($invoice->customer->loyalty_points, 0) }}</strong>
                        </div>
                        <div class="input-group">
                            <input type="number" name="redeem_points" class="form-control bg-black text-white border-secondary" step="1" min="0" max="{{ $invoice->customer->loyalty_points }}" placeholder="النقاط المستبدلة">
                            <span class="input-group-text bg-dark border-secondary text-light">نقاط</span>
                        </div>
                        <div class="form-text text-muted small">أقصى دفع: {{ number_format($invoice->total - $invoice->paid_amount, 2) }}</div>
                    </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label">الخزنة (فقط للدفع النقدي/البنكي)</label>
                        <select name="treasury_id" id="paymentTreasurySelect" class="form-select bg-black text-white border-secondary">
                            <option value="">-- اختر الخزنة --</option>
                            @foreach($treasuries as $treasury)
                                <option value="{{ $treasury->id }}" data-currency="{{ $treasury->currency_id }}" data-currency-code="{{ $treasury->currency ?? 'EGP' }}" data-rate="{{ $treasury->currency_id ? ($treasury->getCurrencyModel->exchange_rate ?? 1) : 1 }}">
                                    {{ $treasury->name }} ({{ number_format($treasury->balance, 2) }} {{ $treasury->currency ?? 'EGP' }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    <button type="submit" class="btn btn-success">حفظ الدفعة</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Handle Treasury Selection to suggest Rate
        const treasurySelect = document.getElementById('paymentTreasurySelect');
        const rateInput = document.getElementById('paymentExchangeRate');
        const invoiceRate = {{ $invoice->exchange_rate ?: 1 }};
        const invoiceCurrencyId = {{ $invoice->currency_id ?: 'null' }};
        
        treasurySelect.addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const treasuryCurrencyId = selectedOption.getAttribute('data-currency');
            const treasuryRate = parseFloat(selectedOption.getAttribute('data-rate'));
            
            // Logic:
            // Invoice in USD (Rate 50). Treasury in EGP (Rate 1).
            // Payment Amount provided in USD.
            // We need to record in Treasury: USD_Amount * TreasuryRate / InvoiceRate? No.
            
            // Core Logic override:
            // User specifies "Amount in Invoice Currency" (e.g. $100).
            // We need to know "Ratio" between Invoice Currency and Treasury Currency.
            // Rate Input should be: How many Treasury Units for 1 Invoice Unit.
            
            // If Invoice USD (50 EGP), Treasury EGP (1 EGP).
            // 1 USD = 50 EGP. Rate = 50.
            
            // If Invoice EGP (1), Treasury USD (50).
            // 1 EGP = 0.02 USD.
            
            // If Invoice USD (50), Treasury EUR (54).
            // 1 USD = (50/54) EUR.
            
            if (!treasuryCurrencyId && !invoiceCurrencyId) {
                rateInput.value = 1;
                return;
            }

             // We rely on Global/Base Rates.
             // Base is EGP (1).
             // Invoice Rate (to Base): IR
             // Treasury Rate (to Base): TR
             
             // Conversion from Invoice to Treasury:
             // 1 InvoiceUnit = IR BaseUnits.
             // 1 TreasuryUnit = TR BaseUnits.
             // 1 InvoiceUnit = (IR / TR) TreasuryUnits.
             
             // Ensure TR is not 0 (should not be).
             // We can fetch rates from backend or data attrs.
             
             // For now simple approach:
             if (treasuryRate > 0) {
                 const ratio = invoiceRate / treasuryRate;
                 rateInput.value = ratio.toFixed(6);
             }
        });
        });

        // Prevention of accidental double payment (Cash + Wallet default)
        const amountInput = document.querySelector('input[name="amount"]');
        const walletInput = document.querySelector('input[name="wallet_amount"]');
        
        if (amountInput && walletInput) {
            const initialAmount = parseFloat(amountInput.value);
            
            // If user touches Wallet Input, and Cash Input is still at default (Full Amount), clear Cash.
            walletInput.addEventListener('focus', function() {
                const currentCash = parseFloat(amountInput.value);
                // Check if Cash is equal to the "Remaining" (which is the default initially)
                // We stored the initial default in a variable, but let's be smarter.
                // If Cash > 0, we zero it out to let user type what they want.
                // User Experience: User clicks "Wallet". System assumes they want to pay via Wallet.
                // Standard behavior: Clear Cash.
                
                if (currentCash > 0) {
                     amountInput.value = 0;
                }
            });

            // Conversely, if user goes back to Cash input and it's 0, maybe restore?
            // No, that's annoying. Let them type.
        }
    });
</script>
@endpush
