@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">{{ __('Journal Entries') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Journal Entries') }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="{{ route('accounting.journals.create') }}" class="btn btn-primary">
                <i class="fas fa-plus-circle me-2"></i>{{ __('New Journal Entry') }}
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('Reference') }}</th>
                            <th>{{ __('Description') }}</th>
                            <th class="text-end">{{ __('Amount') }}</th>
                            <th class="text-center">{{ __('Status') }}</th>
                            <th>{{ __('Posted By') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($entries as $entry)
                            <tr>
                                <td data-label="{{ __('Date') }}">{{ $entry->date->format('Y-m-d') }}</td>
                                <td data-label="{{ __('Reference') }}">{{ $entry->reference ?? '-' }}</td>
                                <td data-label="{{ __('Description') }}">{{ Str::limit($entry->description, 50) }}</td>
                                <td data-label="{{ __('Amount') }}" class="text-end fw-bold">
                                    {{ number_format($entry->lines->sum('debit'), 2) }}</td>
                                <td data-label="{{ __('Status') }}" class="text-center">
                                    @if($entry->locked)
                                        <span class="badge bg-secondary"><i class="fas fa-lock"></i> {{ __('Locked') }}</span>
                                    @else
                                        <span class="badge bg-success">{{ __('Posted') }}</span>
                                    @endif
                                </td>
                                <td data-label="{{ __('Posted By') }}">{{ $entry->user->name ?? 'System' }}</td>
                                <td data-label="{{ __('Actions') }}">
                                    <a href="{{ route('accounting.journals.show', $entry) }}"
                                        class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <i class="fas fa-book fa-3x text-muted mb-3"></i>
                                    <h3>{{ __('No journal entries found') }}</h3>
                                    <p class="text-muted">{{ __('Create a manual entry to adjust accounts.') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($entries->hasPages())
            <div class="card-footer">
                {{ $entries->links() }}
            </div>
        @endif
    </div>
@endsection