@extends('layouts.app')

@section('content')
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title">{{ __('Journal Entry Details') }}</h1>
            <p class="page-subtitle">{{ __('Ref #') }}{{ $journal->reference ?? $journal->id }} |
                {{ $journal->date->format('Y-m-d') }}</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('accounting.journals.index') }}" class="btn btn-outline-light">
                <i class="fas fa-arrow-left me-2"></i>{{ __('Back to List') }}
            </a>
            @if(!$journal->locked)
                <button class="btn btn-danger" onclick="alert('Delete functionality coming soon')">
                    <i class="fas fa-trash me-2"></i>{{ __('Delete') }}
                </button>
            @endif
        </div>
    </div>

    <div class="row g-4">
        <!-- Summary Header -->
        <div class="col-md-12">
            <div class="card glass-card border-0">
                <div class="card-body p-4">
                    <div class="row align-items-center">
                        <div class="col-md-8 border-end border-secondary border-opacity-25">
                            <div class="row g-3">
                                <div class="col-sm-4">
                                    <label
                                        class="text-muted small text-uppercase fw-bold d-block">{{ __('Posting Date') }}</label>
                                    <span class="h5 text-white">{{ $journal->date->format('d M Y') }}</span>
                                </div>
                                <div class="col-sm-4">
                                    <label
                                        class="text-muted small text-uppercase fw-bold d-block">{{ __('Reference') }}</label>
                                    <span class="h5 text-white">{{ $journal->reference ?: '-' }}</span>
                                </div>
                                <div class="col-sm-4">
                                    <label
                                        class="text-muted small text-uppercase fw-bold d-block">{{ __('Entry Type') }}</label>
                                    <span class="badge {{ $journal->is_manual ? 'bg-primary' : 'bg-info' }}">
                                        {{ $journal->is_manual ? __('Manual Entry') : __('System Integrated') }}
                                    </span>
                                </div>
                                <div class="col-12 mt-3">
                                    <label
                                        class="text-muted small text-uppercase fw-bold d-block">{{ __('Description') }}</label>
                                    <p class="mb-0 text-white-50">{{ $journal->description }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 ps-md-4 mt-3 mt-md-0 text-center">
                            <label
                                class="text-muted small text-uppercase fw-bold d-block mb-2">{{ __('Total Amount') }}</label>
                            <div class="h2 text-primary mb-0">
                                {{ number_format($journal->lines->sum('debit'), 2) }} <small
                                    class="fs-6 text-muted">EGP</small>
                            </div>
                            @if($journal->locked)
                                <div class="text-warning small mt-2">
                                    <i class="fas fa-lock me-1"></i> {{ __('Post-dated & Locked') }}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Double-Entry Table -->
        <div class="col-md-12">
            <div class="card glass-card">
                <div class="card-header bg-transparent border-secondary border-opacity-25 py-3">
                    <h5 class="mb-0 overflow-hidden"><i class="fas fa-balance-scale me-2"></i>{{ __('Ledger Movements') }}
                    </h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-black bg-opacity-25">
                            <tr>
                                <th class="ps-4">{{ __('Account Code') }}</th>
                                <th>{{ __('Account Name') }}</th>
                                <th>{{ __('Memo / Description') }}</th>
                                <th class="text-end" style="width: 150px;">{{ __('Debit') }}</th>
                                <th class="text-end pe-4" style="width: 150px;">{{ __('Credit') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($journal->lines as $line)
                                <tr>
                                    <td class="ps-4 fw-bold text-info">{{ $line->account->code }}</td>
                                    <td>
                                        <div class="fw-bold text-white">{{ $line->account->name }}</div>
                                        <div class="small text-muted">{{ $line->account->type }}</div>
                                    </td>
                                    <td class="text-white-50 small">{{ $line->description }}</td>
                                    <td
                                        class="text-end fw-bold {{ $line->debit > 0 ? 'text-success' : 'text-muted opacity-25' }}">
                                        {{ $line->debit > 0 ? number_format($line->debit, 2) : '0.00' }}
                                    </td>
                                    <td
                                        class="text-end pe-4 fw-bold {{ $line->credit > 0 ? 'text-danger' : 'text-muted opacity-25' }}">
                                        {{ $line->credit > 0 ? number_format($line->credit, 2) : '0.00' }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="bg-black bg-opacity-50">
                            <tr class="fw-bold">
                                <td colspan="3" class="text-end ps-4 py-3">{{ __('Totals') }}</td>
                                <td class="text-end border-top border-secondary">
                                    {{ number_format($journal->lines->sum('debit'), 2) }}</td>
                                <td class="text-end pe-4 border-top border-secondary">
                                    {{ number_format($journal->lines->sum('credit'), 2) }}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <!-- Audit Information -->
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center text-muted small px-2">
                <div>
                    <i class="fas fa-user-edit me-1"></i>
                    {{ __('Created by') }} {{ $journal->user->name ?? __('System') }} {{ __('on') }}
                    {{ $journal->created_at->format('Y-m-d H:i') }}
                </div>
                @if($journal->created_at != $journal->updated_at)
                    <div>
                        <i class="fas fa-history me-1"></i>
                        {{ __('Last modified') }} {{ $journal->updated_at->diffForHumans() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection