@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">Profit Calculation & Distribution (توزيع الأرباح)</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.partners.index') }}">Partners</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Calculate Profits</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="card bg-dark border-secondary mb-4">
        <div class="card-body">
            <form action="{{ route('accounting.partners.calculate') }}" method="GET" class="row align-items-end">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="{{ $startDate }}">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">End Date</label>
                    <input type="date" name="end_date" class="form-control" value="{{ $endDate }}">
                </div>
                <div class="col-md-4 mb-3">
                    <button type="submit" class="btn btn-primary w-100">Recalculate Profit</button>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card bg-success text-white">
                <div class="card-body text-center">
                    <h6>Total Net Profit for Period</h6>
                    <h2 class="mb-0">{{ number_format($totalProfit, 2) }} EGP</h2>
                </div>
            </div>
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header bg-secondary text-white fw-bold">Distribution Preview</div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>Recipient</th>
                            <th>Basis (Ownership %)</th>
                            <th>Calculated Profit</th>
                            <th class="text-end">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($partners as $partner)
                            @php $share = ($totalProfit * $partner->ownership_percent) / 100; @endphp
                            <tr>
                                <td>
                                    <div class="fw-bold">{{ $partner->name }}</div>
                                    <div class="small text-muted">Partner</div>
                                </td>
                                <td>{{ $partner->ownership_percent }}%</td>
                                <td class="fw-bold text-success">{{ number_format($share, 2) }} EGP</td>
                                <td class="text-end">
                                    <button class="btn btn-sm btn-outline-success" data-bs-toggle="modal"
                                        data-bs-target="#recordDistModal{{ $partner->id }}">
                                        Record Distribution
                                    </button>

                                    <!-- Distribution Modal -->
                                    <div class="modal fade" id="recordDistModal{{ $partner->id }}" tabindex="-1"
                                        aria-hidden="true text-start">
                                        <div class="modal-dialog">
                                            <div class="modal-content bg-dark border-secondary text-white">
                                                <form action="{{ route('accounting.partners.distribute') }}" method="POST">
                                                    @csrf
                                                    <div class="modal-header border-secondary">
                                                        <h5 class="modal-title">Record Profit Distribution</h5>
                                                        <button type="button" class="btn-close btn-close-white"
                                                            data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body text-start">
                                                        <input type="hidden" name="partner_id" value="{{ $partner->id }}">
                                                        <input type="hidden" name="period_start" value="{{ $startDate }}">
                                                        <input type="hidden" name="period_end" value="{{ $endDate }}">

                                                        <div class="mb-3">
                                                            <label class="form-label">Partner</label>
                                                            <input type="text" class="form-control bg-secondary text-white"
                                                                value="{{ $partner->name }}" readonly>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">Amount (EGP)</label>
                                                            <input type="number" name="amount" class="form-control" step="0.01"
                                                                value="{{ $share }}" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">Distribution Date</label>
                                                            <input type="date" name="date" class="form-control"
                                                                value="{{ date('Y-m-d') }}" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">Notes</label>
                                                            <textarea name="notes" class="form-control"
                                                                rows="2">Profit distribution for period {{ $startDate }} to {{ $endDate }}</textarea>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer border-secondary">
                                                        <button type="button" class="btn btn-outline-light"
                                                            data-bs-dismiss="modal">Close</button>
                                                        <button type="submit" class="btn btn-success">Confirm & Post to
                                                            Ledger</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer bg-transparent border-secondary">
            <div class="alert alert-info mb-0">
                <i class="fas fa-info-circle me-2"></i> Recording a distribution will create a Journal Entry deducting from
                Equity/Profits and potentially the Treasury if paid out.
            </div>
        </div>
    </div>
@endsection