@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Add New Partner') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.partners.index') }}">{{ __('Partners') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Add Partner') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card bg-dark border-secondary">
                <div class="card-header border-secondary bg-secondary text-white fw-bold">
                    {{ __('Partner Information') }}
                </div>
                <div class="card-body">
                    <form action="{{ route('accounting.partners.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Full Name') }}</label>
                                <input type="text" name="name" class="form-control" placeholder="{{ __('e.g. Ahmed Ali') }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Email Address') }}</label>
                                <input type="email" name="email" class="form-control" placeholder="{{ __('ahmed@example.com') }}">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Phone Number') }}</label>
                                <input type="text" name="phone" class="form-control" placeholder="{{ __('+20 123 456 7890') }}">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">{{ __('Ownership %') }}</label>
                                <div class="input-group">
                                    <input type="number" name="ownership_percent" class="form-control" step="0.01" min="0"
                                        max="100" required>
                                    <span class="input-group-text">%</span>
                                </div>
                                <small class="text-muted">{{ __('Percentage of company ownership.') }}</small>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">{{ __('Capital Invested') }}</label>
                                <div class="input-group">
                                    <input type="number" name="capital_invested" class="form-control" step="0.01" min="0"
                                        required>
                                    <span class="input-group-text">EGP</span>
                                </div>
                            </div>
                        </div>

                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary px-4">
                                <i class="fas fa-save me-2"></i> {{ __('Save Partner') }}
                            </button>
                            <a href="{{ route('accounting.partners.index') }}" class="btn btn-outline-light ms-2">{{ __('Cancel') }}</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-info text-white">
                <div class="card-body text-center py-4">
                    <i class="fas fa-user-friends fa-4x mb-3"></i>
                    <h5>{{ __('What is a Partner?') }}</h5>
                    <p class="small mb-0">{{ __('Partners are the primary owners of the company. Profits are distributed at the end of accounting periods based on their ownership percentage.') }}</p>
                </div>
            </div>
        </div>
    </div>
@endsection