@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Edit Partner') }} ({{ __('تعديل بيانات شريك') }})</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.partners.index') }}">{{ __('Partners') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Edit Partner') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card bg-dark border-secondary">
                <div class="card-header border-secondary bg-secondary text-white fw-bold">
                    {{ __('Edit Information:') }} {{ $partner->name }}
                </div>
                <div class="card-body">
                    <form action="{{ route('accounting.partners.update', $partner) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Full Name') }}</label>
                                <input type="text" name="name" class="form-control" value="{{ $partner->name }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Email Address') }}</label>
                                <input type="email" name="email" class="form-control" value="{{ $partner->email }}">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Phone Number') }}</label>
                                <input type="text" name="phone" class="form-control" value="{{ $partner->phone }}">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">{{ __('Ownership %') }}</label>
                                <div class="input-group">
                                    <input type="number" name="ownership_percent" class="form-control" step="0.01" min="0"
                                        max="100" value="{{ $partner->ownership_percent }}" required>
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">{{ __('Capital Invested') }}</label>
                                <div class="input-group">
                                    <input type="number" name="capital_invested" class="form-control" step="0.01" min="0"
                                        value="{{ $partner->capital_invested }}" required>
                                    <span class="input-group-text">EGP</span>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3 form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="is_active" value="1" id="is_active" {{ $partner->is_active ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">{{ __('Active Partner') }}</label>
                        </div>

                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary px-4">
                                <i class="fas fa-save me-2"></i> {{ __('Update Partner') }}
                            </button>
                            <a href="{{ route('accounting.partners.index') }}"
                                class="btn btn-outline-light ms-2">{{ __('Cancel') }}</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection