@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">{{ __('Partners Management') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Partners') }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="{{ route('accounting.partners.calculate') }}" class="btn btn-info text-white">
                <i class="fas fa-calculator me-2"></i>{{ __('Calculate Profits') }}
            </a>
            <a href="{{ route('accounting.partners.create') }}" class="btn btn-primary ms-2">
                <i class="fas fa-plus-circle me-2"></i>{{ __('Add Partner') }}
            </a>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h6 class="card-title opacity-75">{{ __('Total Ownership') }}</h6>
                    <h3 class="mb-0">{{ $partners->sum('ownership_percent') }}%</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h6 class="card-title opacity-75">{{ __('Total Capital Invested') }}</h6>
                    <h3 class="mb-0">{{ number_format($partners->sum('capital_invested'), 2) }} EGP</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h6 class="card-title opacity-75">{{ __('Total Partners') }}</h6>
                    <h3 class="mb-0">{{ $partners->count() }}</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Partner Name') }}</th>
                            <th>{{ __('Ownership %') }}</th>
                            <th>{{ __('Capital Invested') }}</th>
                            <th>{{ __('Distributions') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($partners as $partner)
                            <tr>
                                <td>
                                    <div class="fw-bold">{{ $partner->name }}</div>
                                    <div class="small text-muted">{{ $partner->email }}</div>
                                </td>
                                <td>
                                    <div class="progress" style="height: 10px; width: 100px;">
                                        <div class="progress-bar" role="progressbar"
                                            style="width: {{ $partner->ownership_percent }}%"></div>
                                    </div>
                                    <small>{{ $partner->ownership_percent }}%</small>
                                </td>
                                <td>{{ number_format($partner->capital_invested, 2) }} EGP</td>
                                <td>
                                    <span class="badge bg-secondary">{{ $partner->profit_distributions_count }}
                                        {{ __('Times') }}</span>
                                    Filter
                                </td>
                                <td>
                                    @if($partner->is_active)
                                        <span class="badge bg-success">{{ __('Active') }}</span>
                                    @else
                                        <span class="badge bg-danger">{{ __('Inactive') }}</span>
                                    @endif
                                </td>
                                <td class="text-end">
                                    <div class="btn-group">
                                        <a href="{{ route('accounting.partners.edit', $partner) }}"
                                            class="btn btn-sm btn-outline-light">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('accounting.partners.destroy', $partner) }}" method="POST"
                                            class="d-inline" onsubmit="return confirm('{{ __('Delete this partner?') }}')">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger border-0">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">{{ __('No partners found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection