@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">Import Products from WHMCS</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('products.index') }}">Products & Services</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Import WHMCS</li>
                </ol>
            </nav>
        </div>
    </div>

    @if(empty($products))
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle me-2"></i> No products found in WHMCS or connection failed.
        </div>
        <a href="{{ route('products.index') }}" class="btn btn-secondary">Back to Products</a>
    @else
        <form action="{{ route('products.import.store') }}" method="POST">
            @csrf

            <div class="card mb-4">
                <div class="card-header bg-dark border-secondary d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Select Products to Import</h5>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="selectAll">
                        <label class="form-check-label text-white" for="selectAll">Select All</label>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th width="50" class="text-center">#</th>
                                    <th>Product Name</th>
                                    <th>Group</th>
                                    <th>Description</th>
                                    <th>Price (Monthly)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($products as $group)
                                    @foreach($group['products']['product'] as $product)
                                        <tr>
                                            <td class="text-center">
                                                <input class="form-check-input product-checkbox" type="checkbox"
                                                    name="selected_products[]" value="{{ $product['pid'] }}"
                                                    id="prod_{{ $product['pid'] }}">
                                            </td>
                                            <td>
                                                <label class="form-check-label d-block text-white" for="prod_{{ $product['pid'] }}">
                                                    {{ $product['name'] }}
                                                </label>
                                            </td>
                                            <td><span class="badge bg-secondary">{{ $group['name'] }}</span></td>
                                            <td><small
                                                    class="text-muted">{{ Str::limit(strip_tags($product['description']), 50) }}</small>
                                            </td>
                                            <td>
                                                @if(isset($product['pricing']['EGP']['monthly']))
                                                    {{ $product['pricing']['EGP']['monthly'] }} EGP
                                                @elseif(isset($product['pricing']['USD']['monthly']))
                                                    {{ $product['pricing']['USD']['monthly'] }} USD
                                                @else
                                                    -
                                                @endif
                                            </td>
                                            <!-- Hidden Inputs for Data -->
                                            <input type="hidden" name="products[{{ $product['pid'] }}][name]"
                                                value="{{ $product['name'] }}">
                                            <input type="hidden" name="products[{{ $product['pid'] }}][description]"
                                                value="{{ strip_tags($product['description']) }}">
                                            <input type="hidden" name="products[{{ $product['pid'] }}][price]"
                                                value="{{ $product['pricing']['EGP']['monthly'] ?? ($product['pricing']['USD']['monthly'] ?? 0) }}">
                                        </tr>
                                    @endforeach
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-end gap-2">
                <a href="{{ route('products.index') }}" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-cloud-download-alt me-2"></i> Import Selected
                </button>
            </div>
        </form>
    @endif

    <script>
        document.getElementById('selectAll')?.addEventListener('change', function () {
            document.querySelectorAll('.product-checkbox').forEach(cb => cb.checked = this.checked);
        });
    </script>
@endsection