@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-4">
            <h2 class="fw-light mb-0">{{ __('Programmers Management') }}</h2>
            <p class="text-muted small">{{ __('Manage programmers, track их commissions, and handle payments.') }}</p>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4 g-3">
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body text-center">
                    <h6 class="text-muted small text-uppercase mb-2">{{ __('Total Programmers') }}</h6>
                    <h3 class="fw-bold mb-0">{{ $programmers->total() }}</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover table-dark mb-0 align-middle">
                    <thead class="bg-black">
                        <tr>
                            <th>{{ __('Name') }}</th>
                            <th>{{ __('Contact') }}</th>
                            <th>{{ __('Projects') }}</th>
                            <th>{{ __('Total Earned') }}</th>
                            <th>{{ __('Total Paid') }}</th>
                            <th>{{ __('Outstanding') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($programmers as $programmer)
                            <tr>
                                <td data-label="{{ __('Name') }}">
                                    <div class="fw-bold">{{ $programmer->name }}</div>
                                    <small class="text-muted">ID: #{{ $programmer->id }}</small>
                                </td>
                                <td data-label="{{ __('Contact') }}">
                                    <div><i class="fas fa-envelope me-1 small text-muted"></i>{{ $programmer->email }}</div>
                                    @if($programmer->phone)
                                        <div class="small"><i
                                                class="fas fa-phone me-1 small text-muted"></i>{{ $programmer->phone }}</div>
                                    @endif
                                </td>
                                <td data-label="{{ __('Projects') }}">
                                    <span class="badge bg-info">{{ $programmer->projects_count }} {{ __('Projects') }}</span>
                                </td>
                                <td data-label="{{ __('Total Earned') }}" class="fw-bold">
                                    {{ number_format($programmer->total_earned, 2) }}
                                </td>
                                <td data-label="{{ __('Total Paid') }}" class="text-success">
                                    {{ number_format($programmer->total_paid, 2) }}
                                </td>
                                <td data-label="{{ __('Outstanding') }}"
                                    class="fw-bold {{ $programmer->balance > 0 ? 'text-danger' : 'text-success' }}">
                                    {{ number_format($programmer->balance, 2) }}
                                </td>
                                <td data-label="{{ __('Actions') }}" class="text-end">
                                    <a href="{{ route('accounting.programmers.show', $programmer) }}"
                                        class="btn btn-sm btn-outline-info" title="{{ __('View Account') }}">
                                        <i class="fas fa-user-cog"></i>
                                    </a>
                                    <a href="{{ route('accounting.programmers.edit', $programmer) }}"
                                        class="btn btn-sm btn-outline-light" title="{{ __('Edit') }}">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5 text-muted">{{ __('No programmers found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-3">
                {{ $programmers->links() }}
            </div>
        </div>
    </div>
@endsection