@extends('layouts.app')

@section('content')
    <div class="row mb-4 align-items-center">
        <div class="col-md-6">
            <h2 class="fw-light mb-0">{{ __('Programmer Account') }}: {{ $programmer->name }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a
                            href="{{ route('accounting.programmers.index') }}">{{ __('Programmers') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Account Details') }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-md-6 text-md-end mt-3 mt-md-0">
            <button onclick="window.print()" class="btn btn-outline-light me-2">
                <i class="fas fa-print me-2"></i>{{ __('Print Statement') }}
            </button>
            <a href="{{ route('accounting.programmers.edit', $programmer) }}" class="btn btn-outline-info">
                <i class="fas fa-edit me-2"></i>{{ __('Edit profile') }}
            </a>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4 g-3">
        <div class="col-md-4">
            <div class="card h-100 border-start border-4 border-primary">
                <div class="card-body">
                    <h6 class="text-muted small text-uppercase">{{ __('Total Earned') }}</h6>
                    <h3 class="fw-bold mb-0">{{ number_format($stats['total_earned'], 2) }} <small
                            class="text-muted">EGP</small></h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card h-100 border-start border-4 border-success">
                <div class="card-body">
                    <h6 class="text-muted small text-uppercase text-success">{{ __('Total Paid') }}</h6>
                    <h3 class="fw-bold mb-0 text-success">{{ number_format($stats['total_paid'], 2) }} <small
                            class="text-muted">EGP</small></h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card h-100 border-start border-4 border-danger">
                <div class="card-body">
                    <h6 class="text-muted small text-uppercase text-danger">{{ __('Current Balance') }}</h6>
                    <h3 class="fw-bold mb-0 text-danger">{{ number_format($stats['balance'], 2) }} <small
                            class="text-muted">EGP</small></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabs for Projects and Payments -->
    <div class="card bg-dark border-secondary">
        <div class="card-header bg-black p-0 border-bottom border-secondary">
            <ul class="nav nav-tabs card-header-tabs m-0 border-0" id="programmerTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active border-0 py-3 px-4 text-white" id="projects-tab" data-bs-toggle="tab"
                        data-bs-target="#projects" type="button" role="tab">{{ __('Projects Breakdown') }}</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link border-0 py-3 px-4 text-white" id="payments-tab" data-bs-toggle="tab"
                        data-bs-target="#payments" type="button" role="tab">{{ __('Payment History') }}</button>
                </li>
            </ul>
        </div>
        <div class="card-body p-0">
            <div class="tab-content" id="programmerTabContent">
                <!-- Projects Tab -->
                <div class="tab-pane fade show active" id="projects" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table table-hover table-dark mb-0 align-middle">
                            <thead class="bg-black">
                                <tr>
                                    <th>{{ __('Project') }}</th>
                                    <th>{{ __('Commission') }}</th>
                                    <th>{{ __('Paid') }}</th>
                                    <th>{{ __('Remaining') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th class="text-end">{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($programmer->projects as $project)
                                    <tr>
                                        <td>
                                            <div class="fw-bold">{{ $project->name }}</div>
                                            <small class="text-muted">{{ $project->customer->name ?? '' }}</small>
                                        </td>
                                        <td class="fw-bold">{{ number_format($project->commission_amount, 2) }}</td>
                                        <td class="text-success">{{ number_format($project->paid_to_programmer, 2) }}</td>
                                        <td class="text-danger fw-bold">
                                            {{ number_format($project->remaining_programmer_balance, 2) }}</td>
                                        <td>
                                            <span class="badge bg-{{ $project->status == 'completed' ? 'success' : 'info' }}">
                                                {{ __($project->status) }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <a href="{{ route('accounting.projects.show', $project) }}"
                                                class="btn btn-sm btn-outline-light">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-4 text-muted">{{ __('No projects assigned.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Payments Tab -->
                <div class="tab-pane fade" id="payments" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table table-hover table-dark mb-0 align-middle">
                            <thead class="bg-black">
                                <tr>
                                    <th>{{ __('Date') }}</th>
                                    <th>{{ __('Project') }}</th>
                                    <th>{{ __('Amount') }}</th>
                                    <th>{{ __('Recorder') }}</th>
                                    <th>{{ __('Notes') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($programmer->programmerPayments as $payment)
                                    <tr>
                                        <td>{{ $payment->date ? $payment->date->format('Y-m-d') : '-' }}</td>
                                        <td>{{ $payment->project->name ?? 'N/A' }}</td>
                                        <td class="fw-bold text-success">{{ number_format($payment->amount, 2) }}</td>
                                        <td>{{ $payment->recorder->name ?? 'System' }}</td>
                                        <td class="small text-muted">{{ $payment->notes }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center py-4 text-muted">{{ __('No payments recorded.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection