@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Create New Project') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.projects.index') }}">{{ __('Projects') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Create') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card bg-dark border-secondary text-white">
                <div class="card-body p-4">
                    <form action="{{ route('accounting.projects.store') }}" method="POST">
                        @csrf
                        <div class="mb-4">
                            <label class="form-label">{{ __('Project Name') }}</label>
                            <input type="text" name="name" class="form-control bg-black text-white border-secondary"
                                placeholder="{{ __('e.g. ERP System Development') }}" required>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Customer') }}</label>
                                <select name="customer_id" class="form-select bg-black text-white border-secondary select2"
                                    required>
                                    <option value="">{{ __('Select Customer') }}</option>
                                    @foreach($customers as $customer)
                                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Programmer (Developer)') }}</label>
                                <select name="programmer_id" class="form-select bg-black text-white border-secondary"
                                    required>
                                    <option value="">{{ __('Assign Programmer') }}</option>
                                    @foreach($programmers as $programmer)
                                        <option value="{{ $programmer->id }}">{{ $programmer->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label
                                    class="form-label">{{ __('Total Project Price (Selling price to customer)') }}</label>
                                <div class="input-group">
                                    <input type="number" name="total_price" step="0.01"
                                        class="form-control bg-black text-white border-secondary" required>
                                    <span class="input-group-text bg-secondary border-secondary text-white">EGP</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Programmer Commission') }}</label>
                                <div class="input-group">
                                    <input type="number" name="commission_amount" step="0.01"
                                        class="form-control bg-black text-white border-secondary" required>
                                    <span class="input-group-text bg-secondary border-secondary text-white">EGP</span>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Start Date') }}</label>
                                <input type="date" name="start_date"
                                    class="form-control bg-black text-white border-secondary">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Expected End Date') }}</label>
                                <input type="date" name="end_date"
                                    class="form-control bg-black text-white border-secondary">
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">{{ __('Project Scope / Notes') }}</label>
                            <textarea name="notes" rows="4" class="form-control bg-black text-white border-secondary"
                                placeholder="{{ __('Details about the project...') }}"></textarea>
                        </div>

                        <div class="text-end">
                            <button type="submit" class="btn btn-primary px-5">
                                <i class="fas fa-save me-2"></i>{{ __('Create Project') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection