@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Edit Project:') }} {{ $project->name }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.projects.index') }}">{{ __('Projects') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card bg-dark border-secondary text-white">
                <div class="card-body p-4">
                    <form action="{{ route('accounting.projects.update', $project) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="mb-4">
                            <label class="form-label">{{ __('Project Name') }}</label>
                            <input type="text" name="name" class="form-control bg-black text-white border-secondary"
                                value="{{ $project->name }}" required>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Customer') }}</label>
                                <select name="customer_id" class="form-select bg-black text-white border-secondary select2"
                                    required>
                                    @foreach($customers as $customer)
                                        <option value="{{ $customer->id }}" {{ $project->customer_id == $customer->id ? 'selected' : '' }}>{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Programmer (Developer)') }}</label>
                                <select name="programmer_id" class="form-select bg-black text-white border-secondary"
                                    required>
                                    @foreach($programmers as $programmer)
                                        <option value="{{ $programmer->id }}" {{ $project->programmer_id == $programmer->id ? 'selected' : '' }}>{{ $programmer->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-4">
                                <label class="form-label">{{ __('Status') }}</label>
                                <select name="status" class="form-select bg-black text-white border-secondary" required>
                                    <option value="pending" {{ $project->status == 'pending' ? 'selected' : '' }}>
                                        {{ __('Pending') }}
                                    </option>
                                    <option value="in_progress" {{ $project->status == 'in_progress' ? 'selected' : '' }}>
                                        {{ __('In Progress') }}</option>
                                    <option value="completed" {{ $project->status == 'completed' ? 'selected' : '' }}>
                                        {{ __('Completed') }}
                                    </option>
                                    <option value="on_hold" {{ $project->status == 'on_hold' ? 'selected' : '' }}>
                                        {{ __('On Hold') }}
                                    </option>
                                    <option value="cancelled" {{ $project->status == 'cancelled' ? 'selected' : '' }}>
                                        {{ __('Cancelled') }}
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">{{ __('Total Price (EGP)') }}</label>
                                <input type="number" name="total_price" step="0.01"
                                    class="form-control bg-black text-white border-secondary"
                                    value="{{ $project->total_price }}" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">{{ __('Commssion (EGP)') }}</label>
                                <input type="number" name="commission_amount" step="0.01"
                                    class="form-control bg-black text-white border-secondary"
                                    value="{{ $project->commission_amount }}" required>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-4">
                                <label class="form-label">{{ __('Progress (%)') }}</label>
                                <input type="number" name="progress_percent"
                                    class="form-control bg-black text-white border-secondary" min="0" max="100"
                                    value="{{ $project->progress_percent }}" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">{{ __('Start Date') }}</label>
                                <input type="date" name="start_date"
                                    class="form-control bg-black text-white border-secondary"
                                    value="{{ $project->start_date ? $project->start_date->format('Y-m-d') : '' }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">{{ __('End Date') }}</label>
                                <input type="date" name="end_date" class="form-control bg-black text-white border-secondary"
                                    value="{{ $project->end_date ? $project->end_date->format('Y-m-d') : '' }}">
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">{{ __('Project Scope / Notes') }}</label>
                            <textarea name="notes" rows="4"
                                class="form-control bg-black text-white border-secondary">{{ $project->notes }}</textarea>
                        </div>

                        <div class="text-end">
                            <button type="submit" class="btn btn-info px-5">
                                <i class="fas fa-save me-2"></i>{{ __('Update Project') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection