@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-4">
            <h2 class="fw-light mb-0">{{ __('Project Management') }}</h2>
            <p class="text-muted small">{{ __('Monitor active projects, progress, and programmer performance') }}</p>
        </div>
        <div class="col-12 col-md-8 text-md-end">
            <a href="{{ route('accounting.projects.create') }}" class="btn btn-primary shadow-sm px-4">
                <i class="fas fa-plus-circle me-2"></i>{{ __('New Project') }}
            </a>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4 g-3">
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-primary bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-project-diagram text-primary fa-lg"></i>
                        </div>
                        <span class="text-muted small">{{ __('Active Projects') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold">{{ $stats['active_count'] }}</h3>
                    <div class="text-muted small mt-2">{{ __('Total') }}: {{ $stats['total_count'] }}</div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-success bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-check-circle text-success fa-lg"></i>
                        </div>
                        <span class="text-muted small text-success">{{ __('Completed') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold text-success">{{ $stats['completed_count'] }}</h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-success"
                            style="width: {{ $stats['total_count'] > 0 ? ($stats['completed_count'] / $stats['total_count']) * 100 : 0 }}%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-info">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-info bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-tasks text-info fa-lg"></i>
                        </div>
                        <span class="text-muted small text-info">{{ __('Avg Progress') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold text-info">{{ number_format($stats['avg_progress'], 1) }}%</h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-info" style="width: {{ $stats['avg_progress'] }}%"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-warning bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-dollar-sign text-warning fa-lg"></i>
                        </div>
                        <span class="text-muted small text-warning">{{ __('Total Value') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold">{{ number_format($stats['total_value'], 2) }}</h3>
                    <div class="text-muted small mt-2">{{ __('Project Portfolio') }}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover table-dark mb-0 align-middle">
                    <thead class="bg-black">
                        <tr>
                            <th>{{ __('Project Name') }}</th>
                            <th>{{ __('Customer') }}</th>
                            <th>{{ __('Programmer') }}</th>
                            <th>{{ __('Progress') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Total Price') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($projects as $project)
                            <tr>
                                <td data-label="{{ __('Project Name') }}">
                                    <div class="fw-bold">{{ $project->name }}</div>
                                    <small
                                        class="text-muted">{{ $project->start_date ? $project->start_date->format('M d, Y') : __('No Start Date') }}</small>
                                </td>
                                <td data-label="{{ __('Customer') }}">{{ $project->customer->name ?? __('Unknown Customer') }}
                                </td>
                                <td data-label="{{ __('Programmer') }}">
                                    @if($project->programmer)
                                        <a href="{{ route('accounting.programmers.statement', $project->programmer) }}"
                                            class="text-info text-decoration-none">
                                            {{ $project->programmer->name }}
                                        </a>
                                    @else
                                        <span class="text-muted">{{ __('Unknown Programmer') }}</span>
                                    @endif
                                </td>
                                <td data-label="{{ __('Progress') }}" style="width: 15%">
                                    <div class="progress bg-black" style="height: 10px;">
                                        <div class="progress-bar bg-success" role="progressbar"
                                            style="width: {{ $project->progress_percent }}%"></div>
                                    </div>
                                    <small class="text-muted">{{ $project->progress_percent }}% {{ __('Complete') }}</small>
                                </td>
                                <td data-label="{{ __('Status') }}">
                                    @php
                                        $color = match ($project->status) {
                                            'completed' => 'success',
                                            'in_progress' => 'info',
                                            'on_hold' => 'warning',
                                            'cancelled' => 'danger',
                                            default => 'secondary'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $color }}">{{ __($project->status) }}</span>
                                </td>
                                <td data-label="{{ __('Total Price') }}" class="fw-bold">
                                    {{ number_format($project->total_price, 2) }}
                                </td>
                                <td data-label="{{ __('Actions') }}" class="text-end">
                                    <a href="{{ route('accounting.projects.show', $project) }}"
                                        class="btn btn-sm btn-outline-light">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('accounting.projects.edit', $project) }}"
                                        class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    @can('delete projects')
                                        <form action="{{ route('accounting.projects.destroy', $project) }}" method="POST"
                                            class="d-inline"
                                            onsubmit="return confirm('{{ __('Are you sure you want to delete this project?') }}')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger" title="{{ __('Delete') }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    @endcan
                                </td>

                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5 text-muted">{{ __('No projects found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-3">
                {{ $projects->links() }}
            </div>
        </div>
    </div>
@endsection