@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">Financial Statement: {{ $user->name }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.projects.index') }}">{{ __('Projects') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Statement') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card bg-primary text-white text-center">
                <div class="card-body">
                    <h6 class="opacity-75">Total Earned Commissions</h6>
                    <h3>{{ number_format($user->total_earned, 2) }} EGP</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-success text-white text-center">
                <div class="card-body">
                    <h6 class="opacity-75">Total Received Amount</h6>
                    <h3>{{ number_format($user->total_paid, 2) }} EGP</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-danger text-white text-center">
                <div class="card-body">
                    <h6 class="opacity-75">Remaining Account Balance</h6>
                    <h3>{{ number_format($user->balance, 2) }} EGP</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-header bg-black py-3">
            <h5 class="mb-0 text-white">Project List & Statuses</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-dark mb-0">
                    <thead class="bg-black">
                        <tr>
                            <th>Project</th>
                            <th>Customer</th>
                            <th>Status</th>
                            <th>Commission</th>
                            <th>Paid From Project</th>
                            <th>Project Balance</th>
                            <th class="text-end">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($user->projects as $project)
                            <tr>
                                <td>{{ $project->name }}</td>
                                <td>{{ $project->customer->name }}</td>
                                <td>
                                    <span class="badge bg-{{ $project->status == 'completed' ? 'success' : 'info' }}">
                                        {{ ucfirst($project->status) }} ({{ $project->progress_percent }}%)
                                    </span>
                                </td>
                                <td>{{ number_format($project->commission_amount, 2) }} EGP</td>
                                <td class="text-success">{{ number_format($project->paid_to_programmer, 2) }} EGP</td>
                                <td class="fw-bold text-danger">{{ number_format($project->remaining_programmer_balance, 2) }}
                                    EGP</td>
                                <td class="text-end">
                                    <a href="{{ route('accounting.projects.show', $project) }}"
                                        class="btn btn-sm btn-outline-light">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection