@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="page-title">{{ __('Quotations') }}</h1>
            <p class="page-subtitle">{{ __('Manage price offers and estimates for your customers') }}</p>
        </div>
        <a href="{{ route('accounting.quotations.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>{{ __('New Quotation') }}
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('Number') }}</th>
                            <th>{{ __('Customer') }}</th>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('Expiry') }}</th>
                            <th>{{ __('Total') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($quotations as $quotation)
                            <tr>
                                <td>
                                    <a href="{{ route('accounting.quotations.show', $quotation) }}"
                                        class="fw-bold text-decoration-none">
                                        {{ $quotation->quotation_number }}
                                    </a>
                                </td>
                                <td>{{ $quotation->customer->name }}</td>
                                <td>{{ $quotation->date->format('Y-m-d') }}</td>
                                <td>{{ $quotation->expiry_date ? $quotation->expiry_date->format('Y-m-d') : '-' }}</td>
                                <td>{{ number_format($quotation->grand_total, 2) }}</td>
                                <td>
                                    <span class="badge bg-{{ $quotation->status_color }}">
                                        {{ __($quotation->status) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('accounting.quotations.show', $quotation) }}"
                                            class="btn btn-outline-info" title="{{ __('View') }}">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @if($quotation->status !== 'converted')
                                            <a href="{{ route('accounting.quotations.edit', $quotation) }}"
                                                class="btn btn-outline-warning" title="{{ __('Edit') }}">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('accounting.quotations.convert', $quotation) }}" method="POST"
                                                class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-outline-success"
                                                </button>
                                            </form>
                                            </a>
                                            <form action="{{ route('accounting.quotations.destroy', $quotation) }}" method="POST"
                                                class="d-inline"
                                                onsubmit="return confirm('{{ __('Are you sure you want to delete this quotation?') }}')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-outline-danger" title="{{ __('Delete') }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>

                                        @endif
                                        <a href="{{ route('accounting.quotations.print', $quotation) }}"
                                            class="btn btn-outline-secondary" title="{{ __('Print') }}" target="_blank">
                                            <i class="fas fa-print"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="text-muted mb-2"><i class="fas fa-file-alt fa-3x"></i></div>
                                    <p>{{ __('No quotations found.') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $quotations->links() }}
            </div>
        </div>
    </div>
@endsection