@extends('layouts.print_a4')

@section('title', 'عرض سعر #' . $quotation->quotation_number)
@section('doc_title', 'عرض سعر (Quotation)')

@section('content')
    <div class="doc-meta">
        <div>رقم العرض: <strong>{{ $quotation->quotation_number }}</strong></div>
        <div>التاريخ: <strong>{{ $quotation->date->format('Y-m-d') }}</strong></div>
        <div>صالح حتى: <strong>{{ $quotation->expiry_date ? $quotation->expiry_date->format('Y-m-d') : 'غير محدد' }}</strong></div>
    </div>

    <div class="bill-to" style="margin-bottom: 15px;">
        <div style="border: 1px solid #ddd; padding: 8px; background: #f9f9f9;">
            <h5 style="margin: 0 0 5px 0; border-bottom: 1px solid #ccc; padding-bottom: 5px; font-size: 14px;">موجه إلى:</h5>
            
            <div style="display: flex; justify-content: space-between; margin-bottom: 4px;">
                <div style="font-weight: bold; font-size: 14px;">{{ $quotation->customer->name }}</div>
                <div style="direction: ltr;">{{ $quotation->customer->phone }}</div>
            </div>
            
            @if($quotation->customer->company || $quotation->customer->email)
            <div style="display: flex; justify-content: space-between; margin-bottom: 4px; font-size: 13px;">
                <div>{{ $quotation->customer->company }}</div>
                <div>{{ $quotation->customer->email }}</div>
            </div>
            @endif

            @if($quotation->customer->address)
            <div style="font-size: 12px; color: #555;">
                {{ $quotation->customer->address }}
            </div>
            @endif
        </div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>الوصف</th>
                <th style="width: 10%;">الكمية</th>
                <th style="width: 15%;">سعر الوحدة</th>
                <th style="width: 15%;">الإجمالي</th>
            </tr>
        </thead>
        <tbody>
            @foreach($quotation->items as $item)
                <tr>
                    <td style="text-align: right;">
                        {!! nl2br(e($item->description)) !!}
                    </td>
                    <td>{{ number_format($item->quantity, 2) }}</td>
                    <td>{{ number_format($item->unit_price, 2) }}</td>
                    <td>{{ number_format($item->total, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="totals-section" style="float: left; width: 300px;">
        <table class="totals-table">
            <tr>
                <td>المجموع الفرعي:</td>
                <td style="text-align: left;">{{ number_format($quotation->subtotal, 2) }}</td>
            </tr>
            @if($quotation->discount_value > 0)
                <tr>
                    <td>خصم {{ $quotation->discount_type == 'percent' ? '(' . ($quotation->discount_value + 0) . '%)' : '' }}:</td>
                    <td style="text-align: left;">-{{ number_format($quotation->discount_type == 'percent' ? ($quotation->subtotal * $quotation->discount_value / 100) : $quotation->discount_value, 2) }}</td>
                </tr>
            @endif
            @if($quotation->shipping_amount > 0)
                <tr>
                    <td>شحن:</td>
                    <td style="text-align: left;">{{ number_format($quotation->shipping_amount, 2) }}</td>
                </tr>
            @endif
            @if($quotation->extra_expenses_amount > 0)
                <tr>
                    <td>مصاريف إضافية{{ $quotation->extra_expenses_note ? ' (' . $quotation->extra_expenses_note . ')' : '' }}:</td>
                    <td style="text-align: left;">{{ number_format($quotation->extra_expenses_amount, 2) }}</td>
                </tr>
            @endif
            <tr class="total-row">
                <td>الإجمالي الكلي:</td>
                <td style="text-align: left;">{{ number_format($quotation->grand_total, 2) }} ج.م</td>
            </tr>
        </table>
    </div>

    <div style="clear: both; margin-top: 20px; border-top: 1px solid #eee; padding-top: 10px;">
        @if($quotation->notes)
            <p><strong>ملاحظات:</strong> {{ $quotation->notes }}</p>
        @endif
        @if($quotation->terms)
            <p style="margin-top: 10px;"><strong>الشروط والأحكام:</strong> {{ $quotation->terms }}</p>
        @endif
    </div>

    <div class="signature-section" style="margin-top: 30px; display: flex; justify-content: flex-end; gap: 50px;">
        <div class="signature-box" style="width: 150px; text-align: center;">
            التوقيع
            <div class="signature-line" style="border-top: 1px solid #000; margin-top: 30px;"></div>
        </div>
    </div>
@endsection