@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="page-title">عرض سعر #{{ $quotation->quotation_number }}</h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('accounting.quotations.index') }}">عروض الأسعار</a></li>
                    <li class="breadcrumb-item active">{{ $quotation->quotation_number }}</li>
                </ol>
            </nav>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('accounting.quotations.print', $quotation) }}" target="_blank" class="btn btn-outline-light">
                <i class="fas fa-print me-2"></i>طباعة
            </a>
            @if($quotation->status !== 'converted')
                <a href="{{ route('accounting.quotations.edit', $quotation) }}" class="btn btn-outline-info">
                    <i class="fas fa-edit me-2"></i>تعديل
                </a>
                <form action="{{ route('accounting.quotations.convert', $quotation) }}" method="POST"
                    onsubmit="return confirm('هل أنت متأكد من تحويل عرض السعر إلى فاتورة؟');">
                    @csrf
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-file-invoice-dollar me-2"></i>تحويل إلى فاتورة
                    </button>
                </form>
            @else
                <a href="{{ route('accounting.invoices.show', $quotation->converted_invoice_id) }}" class="btn btn-primary">
                    <i class="fas fa-eye me-2"></i>عرض الفاتورة
                </a>
            @endif
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div
                    class="card-header bg-transparent border-bottom d-flex justify-content-between align-items-center py-3">
                    <h5 class="mb-0">الأصناف</h5>
                    <span class="badge bg-{{ $quotation->status_color }}">{{ __($quotation->status) }}</span>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>الوصف</th>
                                    <th class="text-center">الكمية</th>
                                    <th class="text-end">سعر الوحدة</th>
                                    <th class="text-end">الإجمالي</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($quotation->items as $item)
                                    <tr>
                                        <td>{{ $item->description }}</td>
                                        <td class="text-center">{{ $item->quantity }}</td>
                                        <td class="text-end">{{ number_format($item->unit_price, 2) }}</td>
                                        <td class="text-end fw-bold">{{ number_format($item->total, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <td colspan="3" class="text-end fw-bold">الإجمالي الكلي</td>
                                    <td class="text-end fw-bold fs-5">{{ number_format($quotation->grand_total, 2) }}</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-muted text-uppercase small fw-bold">ملاحظات</h6>
                            <p class="mb-4">{{ $quotation->notes ?? 'لا توجد ملاحظات.' }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-muted text-uppercase small fw-bold">الشروط والأحكام</h6>
                            <p class="mb-0">{{ $quotation->terms ?? 'لا توجد شروط محددة.' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Customer Info -->
            <div class="card mb-4">
                <div class="card-header bg-transparent py-3">
                    <h5 class="card-title mb-0">بيانات العميل</h5>
                </div>
                <div class="card-body">
                    <h5 class="mb-1">{{ $quotation->customer->name }}</h5>
                    <p class="text-muted mb-3">{{ $quotation->customer->company }}</p>

                    <div class="d-flex align-items-center mb-2">
                        <i class="fas fa-envelope text-muted me-3" style="width: 20px"></i>
                        <span>{{ $quotation->customer->email }}</span>
                    </div>
                    @if($quotation->customer->phone)
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-phone text-muted me-3" style="width: 20px"></i>
                            <span>{{ $quotation->customer->phone }}</span>
                        </div>
                    @endif
                    @if($quotation->customer->address)
                        <div class="d-flex align-items-center">
                            <i class="fas fa-map-marker-alt text-muted me-3" style="width: 20px"></i>
                            <span>{{ $quotation->customer->address }}</span>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Meta Info -->
            <div class="card">
                <div class="card-header bg-transparent py-3">
                    <h5 class="card-title mb-0">نظرة عامة</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-3">
                        <span class="text-muted">تاريخ العرض</span>
                        <span class="fw-bold">{{ $quotation->date->format('Y-m-d') }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-3">
                        <span class="text-muted">تاريخ الانتهاء</span>
                        <span
                            class="fw-bold text-{{ $quotation->expiry_date && $quotation->expiry_date->isPast() ? 'danger' : 'success' }}">
                            {{ $quotation->expiry_date ? $quotation->expiry_date->format('Y-m-d') : 'غير محدد' }}
                        </span>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="text-muted">أنشئ بواسطة</span>
                        <small>Admin</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection