@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Edit Subscription') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a
                            href="{{ route('accounting.recurring.index') }}">{{ __('Subscriptions') }}</a></li>
                    <li class="breadcrumb-item active">{{ $recurring->title }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="form-container">
        <form action="{{ route('accounting.recurring.update', $recurring) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header bg-dark border-secondary">
                            <h5 class="mb-0">{{ __('Subscription Settings') }}</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">{{ __('Title') }} <span class="text-danger">*</span></label>
                                <input type="text" name="title" class="form-control" value="{{ $recurring->title }}"
                                    required>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('Frequency') }} <span
                                            class="text-danger">*</span></label>
                                    <select name="frequency" class="form-select" required>
                                        @foreach(['daily', 'weekly', 'monthly', 'quarterly', 'yearly'] as $freq)
                                            <option value="{{ $freq }}" {{ $recurring->frequency == $freq ? 'selected' : '' }}>
                                                {{ __($freq) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('Next Run Date') }} <span
                                            class="text-danger">*</span></label>
                                    <input type="date" name="next_run_date" class="form-control"
                                        value="{{ $recurring->next_run_date->format('Y-m-d') }}" required>
                                </div>
                            </div>

                            <div class="mb-3 form-check">
                                <input type="checkbox" name="is_active" class="form-check-input" id="isActive" {{ $recurring->is_active ? 'checked' : '' }} value="1">
                                <label class="form-check-label" for="isActive">{{ __('Active Subscription') }}</label>
                            </div>

                            <div class="alert alert-info">
                                <i class="fas fa-info-circle me-2"></i>
                                {{ __('Only basic settings can be edited here. To change items, please create a new subscription and archive this one.') }}
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">{{ __('Update Subscription') }}</button>
                                <a href="{{ route('accounting.recurring.index') }}"
                                    class="btn btn-outline-secondary">{{ __('Cancel') }}</a>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header bg-dark border-secondary">
                            <h5 class="mb-0 text-danger">{{ __('Danger Zone') }}</h5>
                        </div>
                        <div class="card-body">
                            <p>{{ __('Stop this subscription permanently?') }}</p>
                            <form action="{{ route('accounting.recurring.destroy', $recurring) }}" method="POST"
                                onsubmit="return confirm('{{ __('Are you sure you want to delete this subscription?') }}');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">{{ __('Delete Subscription') }}</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection