@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">{{ __('Subscriptions (Recurring Invoices)') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Subscriptions') }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="{{ route('accounting.recurring.create') }}" class="btn btn-primary">
                <i class="fas fa-plus-circle me-2"></i>{{ __('New Subscription') }}
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Title') }}</th>
                            <th>{{ __('Customer') }}</th>
                            <th>{{ __('Frequency') }}</th>
                            <th>{{ __('Next Run') }}</th>
                            <th class="text-end">{{ __('Amount') }}</th>
                            <th class="text-center">{{ __('Status') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($recurringInvoices as $sub)
                            <tr>
                                <td class="fw-bold">{{ $sub->title }}</td>
                                <td>{{ $sub->customer->name }}</td>
                                <td><span class="badge bg-info text-dark">{{ __($sub->frequency) }}</span></td>
                                <td>
                                    {{ $sub->next_run_date->format('Y-m-d') }}
                                    @if($sub->next_run_date->isPast() && $sub->is_active)
                                        <span class="text-danger ms-1"><i class="fas fa-exclamation-circle"></i> {{ __('Due') }}</span>
                                    @endif
                                </td>
                                <td class="text-end fw-bold">{{ number_format($sub->amount, 2) }}</td>
                                <td class="text-center">
                                    @if($sub->is_active)
                                        <span class="badge bg-success">{{ __('Active') }}</span>
                                    @else
                                        <span class="badge bg-secondary">{{ __('Inactive') }}</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('accounting.recurring.edit', $sub) }}"
                                        class="btn btn-sm btn-outline-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <i class="fas fa-sync fa-3x text-muted mb-3"></i>
                                    <h3>{{ __('No subscriptions found') }}</h3>
                                    <p class="text-muted">{{ __('Create a subscription to automatically generate invoices.') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($recurringInvoices->hasPages())
            <div class="card-footer">
                {{ $recurringInvoices->links() }}
            </div>
        @endif
    </div>
@endsection