@extends('layouts.app')

@section('content')
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title">{{ __('Cash Flow Dashboard') }}</h1>
            <p class="page-subtitle">{{ __('Annual Financial Overview') }}</p>
        </div>
        <form action="{{ route('accounting.reports.cash_flow') }}" method="GET" class="d-flex gap-2">
            <select name="year" class="form-select w-auto">
                @for($y = date('Y'); $y >= date('Y') - 5; $y--)
                    <option value="{{ $y }}" {{ $year == $y ? 'selected' : '' }}>{{ $y }}</option>
                @endfor
            </select>
            <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-2"></i>{{ __('Filter') }}</button>
            <a href="{{ route('accounting.reports.index') }}" class="btn btn-outline-light">{{ __('Back') }}</a>
        </form>
    </div>

    <!-- Summary Cards (Annual) -->
    <div class="row g-4 mb-4">
        @php
            $totalIncome = array_sum($incomeData);
            $totalExpenses = array_sum($expenseData);
            $netCashFlow = $totalIncome - $totalExpenses;
        @endphp
        <div class="col-md-4">
            <div class="stat-card green h-100">
                <div class="stat-icon"><i class="fas fa-arrow-down"></i></div>
                <div class="stat-value">{{ number_format($totalIncome, 2) }} <small class="fs-6 text-muted">EGP</small>
                </div>
                <div class="stat-label">{{ __('Total Annual Income') }}</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card pink h-100">
                <div class="stat-icon"><i class="fas fa-arrow-up"></i></div>
                <div class="stat-value">{{ number_format($totalExpenses, 2) }} <small class="fs-6 text-muted">EGP</small>
                </div>
                <div class="stat-label">{{ __('Total Annual Expenses') }}</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card {{ $netCashFlow >= 0 ? 'cyan' : 'orange' }} h-100">
                <div class="stat-icon"><i class="fas fa-chart-line"></i></div>
                <div class="stat-value">{{ number_format($netCashFlow, 2) }} <small class="fs-6 text-muted">EGP</small>
                </div>
                <div class="stat-label">{{ __('Net Cash Flow') }}</div>
                <div class="stat-trend {{ $netCashFlow >= 0 ? 'up' : 'down' }}">
                    <i class="fas fa-{{ $netCashFlow >= 0 ? 'arrow-trend-up' : 'arrow-trend-down' }}"></i>
                    {{ $netCashFlow >= 0 ? 'Positive' : 'Negative' }}
                </div>
            </div>
        </div>
    </div>

    <!-- Chart Section -->
    <div class="card bg-dark border-secondary mb-4">
        <div class="card-header bg-black text-white py-3">
            <h5 class="mb-0">{{ __('Monthly Cash Flow Analysis') }}</h5>
        </div>
        <div class="card-body">
            <canvas id="cashFlowChart" height="100"></canvas>
        </div>
    </div>

    <!-- Detailed Table -->
    <div class="card bg-dark border-secondary">
        <div class="card-header bg-black text-white py-3">
            <h5 class="mb-0">{{ __('Monthly Breakdown') }}</h5>
        </div>
        <div class="table-responsive">
            <table class="table table-hover table-dark align-middle mb-0">
                <thead>
                    <tr>
                        <th>{{ __('Month') }}</th>
                        <th class="text-end text-success">{{ __('Income') }}</th>
                        <th class="text-end text-danger">{{ __('Expenses') }}</th>
                        <th class="text-end">{{ __('Net Flow') }}</th>
                        <th class="text-end">{{ __('Outcome') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($months as $index => $month)
                        @php
                            $inc = $incomeData[$index];
                            $exp = $expenseData[$index];
                            $net = $inc - $exp;
                        @endphp
                        <tr>
                            <td>{{ $month }}</td>
                            <td class="text-end fw-bold text-success">{{ number_format($inc, 2) }}</td>
                            <td class="text-end fw-bold text-danger">{{ number_format($exp, 2) }}</td>
                            <td class="text-end fw-bold {{ $net >= 0 ? 'text-info' : 'text-warning' }}">
                                {{ $net >= 0 ? '+' : '' }}{{ number_format($net, 2) }}
                            </td>
                            <td class="text-end">
                                @if($net > 0)
                                    <span class="badge bg-success"><i class="fas fa-check me-1"></i>{{ __('Surplus') }}</span>
                                @elseif($net < 0)
                                    <span class="badge bg-danger"><i
                                            class="fas fa-exclamation-triangle me-1"></i>{{ __('Deficit') }}</span>
                                @else
                                    <span class="badge bg-secondary">{{ __('Balanced') }}</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                var ctx = document.getElementById('cashFlowChart').getContext('2d');
                var cashFlowChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: {!! json_encode($months) !!},
                        datasets: [
                            {
                                label: '{{ __('Income') }}',
                                data: {!! json_encode($incomeData) !!},
                                backgroundColor: 'rgba(16, 185, 129, 0.5)',
                                borderColor: 'rgba(16, 185, 129, 1)',
                                borderWidth: 1,
                                order: 2
                            },
                            {
                                label: '{{ __('Expenses') }}',
                                data: {!! json_encode($expenseData) !!},
                                backgroundColor: 'rgba(239, 68, 68, 0.5)',
                                borderColor: 'rgba(239, 68, 68, 1)',
                                borderWidth: 1,
                                order: 3
                            },
                            {
                                label: '{{ __('Net Flow') }}',
                                data: {!! json_encode(array_map(function ($i, $e) {
            return $i - $e; }, $incomeData, $expenseData)) !!},
                                type: 'line',
                                backgroundColor: 'rgba(6, 182, 212, 0.1)',
                                borderColor: 'rgba(6, 182, 212, 1)',
                                borderWidth: 2,
                                tension: 0.4,
                                pointRadius: 4,
                                borderDash: [5, 5],
                                fill: false,
                                order: 1
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        interaction: {
                            mode: 'index',
                            intersect: false,
                        },
                        plugins: {
                            legend: {
                                position: 'top',
                            },
                            tooltip: {
                                mode: 'index',
                                intersect: false,
                                backgroundColor: 'rgba(10, 14, 20, 0.9)',
                                titleColor: '#fff',
                                bodyColor: '#e2e8f0',
                                borderColor: 'rgba(255, 255, 255, 0.1)',
                                borderWidth: 1,
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                grid: {
                                    color: 'rgba(255, 255, 255, 0.05)'
                                },
                            },
                            x: {
                                grid: {
                                    display: false
                                }
                            }
                        }
                    }
                });
            });
        </script>
    @endpush
@endsection