@extends('layouts.app')

@section('content')
<div class="row mb-4 print-hide">
    <div class="col-12">
        <h2 class="fw-light">{{ __('Customer Account Statement') }}</h2>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('accounting.reports.index') }}">{{ __('Reports') }}</a></li>
                <li class="breadcrumb-item active">{{ __('Customer Statement') }}</li>
            </ol>
        </nav>
    </div>
</div>

<div class="card mb-4 print-hide">
    <div class="card-body">
        <form action="{{ route('accounting.reports.customer_statement') }}" method="GET" class="row g-3 align-items-end">
            <div class="col-md-6">
                <label class="form-label">{{ __('Select Customer') }}</label>
                <select name="customer_id" class="form-select" required>
                    <option value="">-- {{ __('Choose Customer') }} --</option>
                    @foreach($customers as $c)
                        <option value="{{ $c->id }}" {{ isset($selectedCustomer) && $selectedCustomer->id == $c->id ? 'selected' : '' }}>
                            {{ $c->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">{{ __('Start Date') }}</label>
                <input type="date" name="start_date" class="form-control" value="{{ request('start_date', date('Y-01-01')) }}">
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary w-100"><i class="fas fa-search me-2"></i>{{ __('Display') }}</button>
            </div>
        </form>
    </div>
</div>

@if($selectedCustomer)
<div class="card">
    <div class="card-header bg-dark border-secondary d-flex justify-content-between align-items-center">
        <h5 class="mb-0">{{ __('Statement for:') }} <span class="text-primary">{{ $selectedCustomer->name }}</span></h5>
        <a href="{{ route('accounting.reports.customer_statement.print', ['customer_id' => $selectedCustomer->id, 'start_date' => request('start_date'), 'end_date' => request('end_date')]) }}" target="_blank" class="btn btn-sm btn-outline-light print-hide"><i class="fas fa-print"></i> {{ __('Premium A4 Print') }}</a>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover table-striped mb-0">
                <thead class="table-dark">
                    <tr>
                        <th>{{ __('Date') }}</th>
                        <th>{{ __('Type') }}</th>
                        <th>{{ __('Reference') }}</th>
                        <th>{{ __('Description') }}</th>
                        <th class="text-end">{{ __('Debit (Bill)') }}</th>
                        <th class="text-end">{{ __('Credit (Pay)') }}</th>
                        <th class="text-end">{{ __('Balance') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @php $balance = 0; @endphp
                    @foreach($transactions as $trans)
                        @php 
                            $balance += ($trans['debit'] - $trans['credit']); 
                        @endphp
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($trans['date'])->format('Y-m-d') }}</td>
                            <td><span class="badge {{ $trans['type'] == 'Invoice' ? 'bg-primary' : 'bg-success' }}">{{ $trans['type'] }}</span></td>
                            <td>{{ $trans['ref'] }}</td>
                            <td>{{ $trans['description'] }}</td>
                            <td class="text-end">{{ $trans['debit'] > 0 ? number_format($trans['debit'], 2) : '-' }}</td>
                            <td class="text-end">{{ $trans['credit'] > 0 ? number_format($trans['credit'], 2) : '-' }}</td>
                            <td class="text-end fw-bold">{{ number_format($balance, 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot class="table-dark">
                    <tr>
                        <th colspan="6" class="text-end">{{ __('Ending Balance:') }}</th>
                        <th class="text-end {{ $balance > 0 ? 'text-danger' : 'text-success' }}">{{ number_format($balance, 2) }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
@endif

<style>
@media print {
    .print-hide { display: none !important; }
    .card { border: none !important; }
    body { background-color: #fff !important; color: #000 !important; }
    .table-dark { color: #000 !important; background-color: transparent !important; border-bottom: 2px solid #000; }
    .text-white { color: #000 !important; }
}
</style>
@endsection
