@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">{{ __('Equity Statement') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.reports.index') }}">{{ __('Reports') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Equity Statement') }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <button onclick="window.print()" class="btn btn-outline-light">
                <i class="fas fa-print me-2"></i>{{ __('Print Report') }}
            </button>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h6 class="opacity-75">{{ __('Total Capital') }}</h6>
                    <h3>{{ number_format($totalCapital, 2) }} {{ __('EGP') }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h6 class="opacity-75">{{ __('Retained Earnings') }}</h6>
                    <h3>{{ number_format($retainedEarnings, 2) }} {{ __('EGP') }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h6 class="opacity-75">{{ __('Distributed Profits') }}</h6>
                    <h3>{{ number_format($distributions, 2) }} {{ __('EGP') }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-dark">
                <div class="card-body">
                    <h6 class="opacity-75">{{ __('Total Equity') }}</h6>
                    <h3>{{ number_format($totalCapital + $retainedEarnings, 2) }} {{ __('EGP') }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Partners Equity -->
    <div class="card mb-4">
        <div class="card-header bg-dark border-secondary">
            <h5 class="mb-0">{{ __('Partners Equity Breakdown') }}</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Partner Name') }}</th>
                            <th>{{ __('Ownership %') }}</th>
                            <th>{{ __('Capital Basis') }}</th>
                            <th>{{ __('Share of Retained Earnings') }}</th>
                            <th>{{ __('Total Individual Equity') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($partners as $partner)
                            @php
                                $reShare = ($retainedEarnings * $partner->ownership_percent) / 100;
                                // In a complex system, capital would be specific per partner in lines.
                                // For now, we take total capital * ownership.
                                $capShare = ($totalCapital * $partner->ownership_percent) / 100;
                            @endphp
                            <tr>
                                <td>{{ $partner->name }}</td>
                                <td>{{ $partner->ownership_percent }}%</td>
                                <td>{{ number_format($capShare, 2) }} {{ __('EGP') }}</td>
                                <td>{{ number_format($reShare, 2) }} {{ __('EGP') }}</td>
                                <td class="fw-bold">{{ number_format($capShare + $reShare, 2) }} {{ __('EGP') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Investors Info (Summary) -->
    <div class="card">
        <div class="card-header bg-dark border-secondary text-white">
            <h5 class="mb-0">{{ __('Investors & Shares Summary') }}</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Investor') }}</th>
                            <th>{{ __('Shares') }}</th>
                            <th>{{ __('Investment Basis') }}</th>
                            <th>{{ __('Avg. Cost') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($investors as $investor)
                            <tr>
                                <td>{{ $investor->name }}</td>
                                <td>{{ number_format($investor->total_shares) }}</td>
                                <td>{{ number_format($investor->total_investment, 2) }} {{ __('EGP') }}</td>
                                <td>{{ number_format($investor->avg_purchase_price, 2) }} {{ __('EGP') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection