@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light mb-0">{{ __('Expenses Breakdown') }}</h2>
            <p class="text-muted small">{{ __('Analyze spending patterns by supplier and category') }}</p>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('accounting.reports.index') }}">{{ __('Reports') }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Expenses Breakdown') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="card mb-4 border-0 shadow-sm glass-card">
        <div class="card-body">
            <form method="GET" action="{{ route('accounting.reports.expenses_breakdown') }}"
                class="row g-3 align-items-center">
                <div class="col-md-3">
                    <label class="form-label small text-muted text-uppercase fw-bold">{{ __('Start Date') }}</label>
                    <input type="date" name="start_date" class="form-control bg-dark border-secondary text-light"
                        value="{{ $startDate }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label small text-muted text-uppercase fw-bold">{{ __('End Date') }}</label>
                    <input type="date" name="end_date" class="form-control bg-dark border-secondary text-light"
                        value="{{ $endDate }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label d-block">&nbsp;</label>
                    <button type="submit" class="btn btn-primary px-4">
                        <i class="fas fa-filter me-2"></i>{{ __('Filter') }}
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-md-7">
            <div class="card border-0 shadow-sm glass-card h-100">
                <div class="card-header bg-transparent border-bottom border-secondary py-3">
                    <h5 class="mb-0 fw-bold"><i
                            class="fas fa-chart-pie text-warning me-2"></i>{{ __('Allocation Summary') }}</h5>
                </div>
                <div class="card-body d-flex align-items-center justify-content-center p-4">
                    <div style="width: 100%; max-width: 400px;">
                        <canvas id="expensesChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-5">
            <div class="card border-0 shadow-sm glass-card h-100">
                <div class="card-header bg-transparent border-bottom border-secondary py-3">
                    <h5 class="mb-0 fw-bold">{{ __('Detailed Spending') }}</h5>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush bg-transparent">
                        @foreach($labels as $index => $label)
                            <div
                                class="list-group-item bg-transparent border-secondary text-light d-flex justify-content-between align-items-center py-3">
                                <div>
                                    <span class="badge rounded-circle p-2 me-2"
                                        style="background-color: {{ ['#3498db', '#e74c3c', '#9b59b6', '#2ecc71', '#f1c40f', '#e67e22', '#1abc9c', '#34495e'][$index % 8] }}">&nbsp;</span>
                                    {{ $index + 1 }}. {{ $label }}
                                </div>
                                <span class="fw-bold">EGP {{ number_format($data[$index], 2) }}</span>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const ctx = document.getElementById('expensesChart').getContext('2d');
            new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: @json($labels),
                    datasets: [{
                        data: @json($data),
                        backgroundColor: [
                            '#3498db', '#e74c3c', '#9b59b6', '#2ecc71', '#f1c40f', '#e67e22', '#1abc9c', '#34495e'
                        ],
                        borderWidth: 2,
                        borderColor: 'rgba(30, 30, 30, 0.5)',
                        hoverOffset: 15
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%',
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            backgroundColor: 'rgba(20, 20, 20, 0.9)',
                            padding: 12,
                            displayColors: true,
                            callbacks: {
                                label: function (context) {
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = ((context.parsed / total) * 100).toFixed(1);
                                    return context.label + ': EGP ' + context.parsed.toLocaleString() + ' (' + percentage + '%)';
                                }
                            }
                        }
                    }
                }
            });
        });
    </script>
@endsection