@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="page-header d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="page-title">{{ __('HR & Payroll Summary') }}</h1>
                <p class="page-subtitle">{{ __('Employee attendance and salary trends') }}</p>
            </div>
            <form action="{{ route('accounting.reports.hr_report') }}" method="GET" class="d-flex gap-2">
                <input type="date" name="start_date" class="form-control" value="{{ $startDate }}" required>
                <input type="date" name="end_date" class="form-control" value="{{ $endDate }}" required>
                <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-2"></i>{{ __('Filter') }}</button>
                <a href="{{ route('accounting.reports.index') }}" class="btn btn-outline-light">{{ __('Back to Hub') }}</a>
            </form>
        </div>

        <!-- HR Stats -->
        <div class="row g-4 mb-4">
            <div class="col-md-4">
                <div class="stat-card blue">
                    <div class="stat-icon"><i class="fas fa-money-bill-wave"></i></div>
                    <div class="stat-value">{{ number_format($totalSalaries, 2) }}</div>
                    <div class="stat-label">{{ __('Total Salaries Paid') }}</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card orange">
                    <div class="stat-icon"><i class="fas fa-user-clock"></i></div>
                    <div class="stat-value">{{ number_format($attendanceRate, 1) }}%</div>
                    <div class="stat-label">{{ __('Avg. Attendance Rate') }}</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card purple">
                    <div class="stat-icon"><i class="fas fa-building"></i></div>
                    <div class="stat-value">{{ $employeeStats->count() }}</div>
                    <div class="stat-label">{{ __('Active Departments') }}</div>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <!-- Department Diversity -->
            <div class="col-lg-12">
                <div class="card glass-card">
                    <div class="card-header border-bottom border-light py-3">
                        <h5 class="mb-0 fw-bold">{{ __('Employee Distribution by Department') }}</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="bg-black text-muted small uppercase">
                                    <tr>
                                        <th>{{ __('Department') }}</th>
                                        <th class="text-center">{{ __('Employee Count') }}</th>
                                        <th>{{ __('Status') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($employeeStats as $dept)
                                        <tr>
                                            <td class="fw-bold">{{ $dept->name }}</td>
                                            <td class="text-center">{{ $dept->employees_count }}</td>
                                            <td>
                                                <div class="progress" style="height: 8px; width: 200px;">
                                                    <div class="progress-bar bg-primary"
                                                        style="width: {{ ($dept->employees_count / max(1, $employeeStats->sum('employees_count'))) * 100 }}%">
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection