@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="page-header mb-5">
            <h1 class="page-title text-center fw-bold fs-2"><i
                    class="fas fa-chart-pie me-2 text-primary"></i>{{ __('Central Reporting Hub') }}</h1>
            <p class="page-subtitle text-center mx-auto" style="max-width: 600px;">
                {{ __('Access deep insights across all business modules with our comprehensive analytical tools.') }}</p>
        </div>

        <!-- Main Categories -->
        <div class="row g-4">
            <!-- Financial Analysis -->
            <div class="col-12 mt-4">
                <h5 class="section-title mb-3"><i class="fas fa-university me-2"></i>{{ __('Financial Analytics') }}</h5>
                <div class="row g-4">
                    <div class="col-md-4 col-xl-3">
                        <a href="{{ route('accounting.reports.profit_loss') }}" class="report-card primary">
                            <div class="icon-box"><i class="fas fa-chart-line"></i></div>
                            <div class="content">
                                <h6>{{ __('Profit & Loss') }}</h6>
                                <p>{{ __('Accrual-based income vs expenses summary.') }}</p>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4 col-xl-3">
                        <a href="{{ route('accounting.reports.treasury_balance') }}" class="report-card warning">
                            <div class="icon-box"><i class="fas fa-vault"></i></div>
                            <div class="content">
                                <h6>{{ __('Treasury Balances') }}</h6>
                                <p>{{ __('Real-time snapshot of all safe balances.') }}</p>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4 col-xl-3">
                        <a href="{{ route('accounting.reports.cash_flow') }}" class="report-card info">
                            <div class="icon-box"><i class="fas fa-exchange-alt"></i></div>
                            <div class="content">
                                <h6>{{ __('Cash Flow') }}</h6>
                                <p>{{ __('Monthly liquidity and cash movement analysis.') }}</p>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4 col-xl-3">
                        <a href="{{ route('accounting.reports.vat_return') }}" class="report-card secondary">
                            <div class="icon-box"><i class="fas fa-file-invoice-dollar"></i></div>
                            <div class="content">
                                <h6>{{ __('VAT Return') }}</h6>
                                <p>{{ __('Tax report for filing and compliance.') }}</p>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Sales & CRM -->
            <div class="col-12 mt-5">
                <h5 class="section-title mb-3"><i
                        class="fas fa-shopping-cart me-2"></i>{{ __('Sales & Customer Analytics') }}</h5>
                <div class="row g-4">
                    <div class="col-md-4 col-xl-3">
                        <a href="{{ route('accounting.reports.sales_analysis') }}" class="report-card green">
                            <div class="icon-box"><i class="fas fa-funnel-dollar"></i></div>
                            <div class="content">
                                <h6>{{ __('Sales Performance') }}</h6>
                                <p>{{ __('Detailed analysis of revenue and growth.') }}</p>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4 col-xl-3">
                        <a href="{{ route('accounting.reports.customer_statement') }}" class="report-card cyan">
                            <div class="icon-box"><i class="fas fa-users-cog"></i></div>
                            <div class="content">
                                <h6>{{ __('Customer Statements') }}</h6>
                                <p>{{ __('Ledger and transaction history for clients.') }}</p>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4 col-xl-3">
                        <a href="{{ route('accounting.quotations.index') }}" class="report-card purple">
                            <div class="icon-box"><i class="fas fa-file-contract"></i></div>
                            <div class="content">
                                <h6>{{ __('Quotation Conversion') }}</h6>
                                <p>{{ __('Track proposals converted to active orders.') }}</p>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Inventory & HR -->
            <div class="col-lg-6 mt-5">
                <h5 class="section-title mb-3"><i class="fas fa-boxes me-2"></i>{{ __('Inventory & Logistics') }}</h5>
                <div class="row g-4">
                    <div class="col-md-6">
                        <a href="{{ route('accounting.reports.inventory_report') }}" class="report-card orange">
                            <div class="icon-box"><i class="fas fa-warehouse"></i></div>
                            <div class="content">
                                <h6>{{ __('Stock Status') }}</h6>
                                <p>{{ __('Current inventory levels and low stock alerts.') }}</p>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="#" class="report-card pink">
                            <div class="icon-box"><i class="fas fa-truck-loading"></i></div>
                            <div class="content">
                                <h6>{{ __('Product Movements') }}</h6>
                                <p>{{ __('Summary of items in and out of stock.') }}</p>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 mt-5">
                <h5 class="section-title mb-3"><i class="fas fa-user-friends me-2"></i>{{ __('HR & Performance') }}</h5>
                <div class="row g-4">
                    <div class="col-md-6">
                        <a href="{{ route('accounting.reports.hr_report') }}" class="report-card blue">
                            <div class="icon-box"><i class="fas fa-calendar-check"></i></div>
                            <div class="content">
                                <h6>{{ __('Attendance & Payroll') }}</h6>
                                <p>{{ __('Employee presence and salary summaries.') }}</p>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="{{ route('accounting.reports.operations_report') }}" class="report-card teal">
                            <div class="icon-box"><i class="fas fa-headset"></i></div>
                            <div class="content">
                                <h6>{{ __('Operations Summary') }}</h6>
                                <p>{{ __('Support tickets and service health.') }}</p>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .section-title {
            font-weight: 700;
            font-size: 1.1rem;
            color: #94a3b8;
            text-transform: uppercase;
            letter-spacing: 1px;
            border-bottom: 2px solid rgba(255, 255, 255, 0.05);
            padding-bottom: 0.5rem;
        }

        .report-card {
            display: flex;
            align-items: center;
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.05);
            border-radius: 1.25rem;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            height: 100%;
            position: relative;
            overflow: hidden;
            backdrop-filter: blur(10px);
        }

        .report-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.03));
            z-index: 0;
        }

        .report-card:hover {
            transform: translateY(-5px);
            background: rgba(255, 255, 255, 0.06);
            border-color: rgba(255, 255, 255, 0.15);
            box-shadow: 0 10px 30px -5px rgba(0, 0, 0, 0.3);
        }

        .report-card .icon-box {
            width: 54px;
            height: 54px;
            border-radius: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-right: 1.25rem;
            flex-shrink: 0;
            transition: all 0.3s;
            z-index: 1;
        }

        .report-card .content {
            z-index: 1;
        }

        .report-card .content h6 {
            margin-bottom: 0.25rem;
            font-weight: 700;
            color: #f8fafc;
            font-size: 1.05rem;
        }

        .report-card .content p {
            margin-bottom: 0;
            font-size: 0.85rem;
            color: #94a3b8;
            line-height: 1.4;
        }

        /* Color Themes */
        .report-card.primary .icon-box {
            background: rgba(59, 130, 246, 0.1);
            color: #3b82f6;
        }

        .report-card.warning .icon-box {
            background: rgba(245, 158, 11, 0.1);
            color: #f59e0b;
        }

        .report-card.info .icon-box {
            background: rgba(6, 182, 212, 0.1);
            color: #06b6d4;
        }

        .report-card.secondary .icon-box {
            background: rgba(148, 163, 184, 0.1);
            color: #94a3b8;
        }

        .report-card.green .icon-box {
            background: rgba(16, 185, 129, 0.1);
            color: #10b981;
        }

        .report-card.cyan .icon-box {
            background: rgba(34, 211, 238, 0.1);
            color: #22d3ee;
        }

        .report-card.purple .icon-box {
            background: rgba(139, 92, 246, 0.1);
            color: #8b5cf6;
        }

        .report-card.orange .icon-box {
            background: rgba(249, 115, 22, 0.1);
            color: #f97316;
        }

        .report-card.pink .icon-box {
            background: rgba(236, 72, 153, 0.1);
            color: #ec4899;
        }

        .report-card.blue .icon-box {
            background: rgba(37, 99, 235, 0.1);
            color: #2563eb;
        }

        .report-card.teal .icon-box {
            background: rgba(20, 184, 166, 0.1);
            color: #14b8a6;
        }

        [dir="rtl"] .report-card .icon-box {
            margin-right: 0;
            margin-left: 1.25rem;
        }
    </style>
@endsection