@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="page-header d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="page-title">{{ __('Inventory & Stock Report') }}</h1>
                <p class="page-subtitle">{{ __('Current stock levels and movement analysis') }}</p>
            </div>
            <a href="{{ route('accounting.reports.index') }}" class="btn btn-outline-light">{{ __('Back to Hub') }}</a>
        </div>

        <!-- Stock Status by Warehouse -->
        @foreach($warehouses as $warehouse)
            <div class="card glass-card mb-4">
                <div class="card-header border-bottom border-light py-3 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold text-primary"><i class="fas fa-warehouse me-2"></i>{{ $warehouse->name }}</h5>
                    <span class="badge bg-soft-info text-info">{{ $warehouse->products->count() }} {{ __('Items') }}</span>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="bg-black text-muted small uppercase">
                                <tr>
                                    <th>{{ __('Product') }}</th>
                                    <th>{{ __('Code') }}</th>
                                    <th class="text-center">{{ __('Current Stock') }}</th>
                                    <th class="text-center">{{ __('Min Stock') }}</th>
                                    <th class="text-end">{{ __('Value (Est.)') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($warehouse->products as $product)
                                    <tr class="{{ $product->stock <= $product->min_stock ? 'bg-soft-danger' : '' }}">
                                        <td>{{ $product->name }}</td>
                                        <td><code class="text-muted">{{ $product->code }}</code></td>
                                        <td
                                            class="text-center fw-bold {{ $product->stock <= $product->min_stock ? 'text-danger' : 'text-success' }}">
                                            {{ $product->stock }} {{ $product->unit->name ?? '' }}
                                        </td>
                                        <td class="text-center text-muted small">{{ $product->min_stock }}</td>
                                        <td class="text-end">{{ number_format($product->stock * $product->price, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endforeach

        <div class="row g-4">
            <!-- Low Stock Alerts -->
            <div class="col-lg-6">
                <div class="card border-0 shadow-sm bg-danger bg-opacity-10 h-100">
                    <div class="card-header bg-transparent border-0 py-3">
                        <h5 class="mb-0 fw-bold text-danger"><i
                                class="fas fa-exclamation-triangle me-2"></i>{{ __('Critical Low Stock') }}</h5>
                    </div>
                    <div class="card-body p-0">
                        <ul class="list-group list-group-flush bg-transparent">
                            @forelse($lowStockProducts as $lp)
                                <li
                                    class="list-group-item bg-transparent d-flex justify-content-between align-items-center py-3">
                                    <div>
                                        <h6 class="mb-0">{{ $lp->name }}</h6>
                                        <small class="text-muted">{{ __('Warehouse') }}:
                                            {{ $lp->warehouse->name ?? '---' }}</small>
                                    </div>
                                    <span class="badge bg-danger rounded-pill">{{ $lp->stock }} / {{ $lp->min_stock }}</span>
                                </li>
                            @empty
                                <li class="list-group-item bg-transparent text-center py-4 text-muted">
                                    {{ __('No critical stock alerts.') }}</li>
                            @endforelse
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Top Selling Products -->
            <div class="col-lg-6">
                <div class="card glass-card h-100">
                    <div class="card-header border-bottom border-light py-3">
                        <h5 class="mb-0 fw-bold"><i
                                class="fas fa-fire me-2 text-warning"></i>{{ __('Top Products by Volume') }}</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="bg-black text-muted small uppercase">
                                    <tr>
                                        <th>{{ __('Product') }}</th>
                                        <th class="text-end">{{ __('Qty Sold') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($topProductsByVolume as $tp)
                                        <tr>
                                            <td>{{ $tp->product->name ?? '---' }}</td>
                                            <td class="text-end fw-bold text-warning">{{ $tp->total_qty }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .bg-soft-danger {
            background-color: rgba(239, 68, 68, 0.05);
        }

        .bg-soft-info {
            background-color: rgba(6, 182, 212, 0.1);
        }
    </style>
@endsection