@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="page-header d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="page-title">{{ __('Operations & Support Analysis') }}</h1>
                <p class="page-subtitle">{{ __('Ticket health and license subscription trends') }}</p>
            </div>
            <a href="{{ route('accounting.reports.index') }}" class="btn btn-outline-light">{{ __('Back to Hub') }}</a>
        </div>

        <div class="row g-4">
            <!-- Ticket Stats -->
            <div class="col-lg-6">
                <div class="card glass-card h-100">
                    <div class="card-header border-bottom border-light py-3">
                        <h5 class="mb-0 fw-bold"><i
                                class="fas fa-ticket-alt me-2 text-info"></i>{{ __('Support Ticket Status') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-4">
                            @foreach($ticketStats as $stat)
                                <div class="col-6">
                                    <div class="p-3 rounded border border-light text-center">
                                        <h3 class="fw-bold mb-1">{{ $stat->count }}</h3>
                                        <div class="text-muted small uppercase">{{ __(ucfirst($stat->status)) }}</div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <!-- Subscription Health -->
            <div class="col-lg-6">
                <div class="card glass-card h-100">
                    <div class="card-header border-bottom border-light py-3">
                        <h5 class="mb-0 fw-bold"><i
                                class="fas fa-sync me-2 text-success"></i>{{ __('Subscription & Service Health') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-4 p-3 bg-soft-success rounded">
                            <div>
                                <h6 class="mb-1 fw-bold">{{ __('Active Subscriptions') }}</h6>
                                <p class="text-muted small mb-0">{{ __('Total currently providing recurring revenue') }}</p>
                            </div>
                            <h2 class="mb-0 fw-black text-success">{{ $activeSubscriptions }}</h2>
                        </div>

                        <div class="d-flex align-items-center justify-content-between p-3 bg-soft-warning rounded">
                            <div>
                                <h6 class="mb-1 fw-bold">{{ __('Expiring Soon') }}</h6>
                                <p class="text-muted small mb-0">{{ __('Renewals due within the next 30 days') }}</p>
                            </div>
                            <h2 class="mb-0 fw-black text-warning">{{ $expiringSoon }}</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .bg-soft-success {
            background: rgba(16, 185, 129, 0.1);
        }

        .bg-soft-warning {
            background: rgba(245, 158, 11, 0.1);
        }
    </style>
@endsection