@extends('layouts.print_a4')

@section('title', __('Customer Statement') . ' - ' . $selectedCustomer->name)
@section('doc_title', __('Customer Statement'))

@section('content')
    <div class="doc-meta">
        <div>{{ __('Customer:') }} <strong>{{ $selectedCustomer->name }}</strong></div>
        <div>{{ __('Period From:') }} <strong>{{ $startDate }}</strong> {{ __('To:') }} <strong>{{ $endDate }}</strong>
        </div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>{{ __('Date') }}</th>
                <th>{{ __('Type') }}</th>
                <th>{{ __('Reference') }}</th>
                <th>{{ __('Debit') }}</th>
                <th>{{ __('Credit') }}</th>
                <th>{{ __('Balance') }}</th>
            </tr>
        </thead>
        <tbody>
            @php $balance = 0; @endphp
            @foreach($transactions as $trans)
                @php 
                    $balance += ($trans->debit - $trans->credit);
                @endphp
                <tr>
                    <td>{{ $trans->date->format('Y-m-d') }}</td>
                    <td>{{ $trans->type == 'Invoice' ? __('Sales Invoice') : __('Receipt Voucher') }}</td>
                    <td>{{ $trans->ref }}</td>
                    <td>{{ $trans->debit > 0 ? number_format($trans->debit, 2) : '-' }}</td>
                    <td>{{ $trans->credit > 0 ? number_format($trans->credit, 2) : '-' }}</td>
                        <td dir="ltr">{{ number_format($balance, 2) }}</td>
                    </tr>
            @endforeach
        </tbody>
    </table>

    <div class="totals-section">
        <table class="totals-table">
            <tr>
                <td>{{ __('Total Bills:') }}</td>
                <td style="text-align: left;">{{ number_format($transactions->sum('debit'), 2) }}</td>
            </tr>
            <tr>
                <td>{{ __('Total Payments:') }}</td>
                <td style="text-align: left;">{{ number_format($transactions->sum('credit'), 2) }}</td>
            </tr>
            <tr class="total-row">
                <td>{{ __('Final Balance:') }}</td>
                <td style="text-align: left;">{{ number_format($balance, 2) }} {{ __('EGP') }}</td>
            </tr>
        </table>
    </div>

    <div class="signature-section">
        <div class="signature-box">
            {{ __('Customer Signature') }}
            <div class="signature-line"></div>
        </div>
        <div class="signature-box">
            {{ __('Accountant Approval') }}
            <div class="signature-line"></div>
        </div>    </div>
@endsection
