@extends('layouts.app')

@section('content')
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title">{{ __('Profit & Loss Report') }}</h1>
            <p class="page-subtitle">{{ __('Income vs Expenses Analysis') }}</p>
        </div>
        <form action="{{ route('accounting.reports.profit_loss') }}" method="GET" class="d-flex gap-2">
            <input type="date" name="start_date" class="form-control" value="{{ $startDate }}" required>
            <input type="date" name="end_date" class="form-control" value="{{ $endDate }}" required>
            <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-2"></i>{{ __('Filter') }}</button>
            <a href="{{ route('accounting.reports.index') }}" class="btn btn-outline-light">{{ __('Back') }}</a>
        </form>
    </div>

    <!-- Summary Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="stat-card green h-100">
                <div class="stat-icon"><i class="fas fa-hand-holding-usd"></i></div>
                <div class="stat-value">{{ number_format($revenue, 2) }}</div>
                <div class="stat-label">{{ __('Total Revenue') }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card orange h-100">
                <div class="stat-icon"><i class="fas fa-shopping-cart"></i></div>
                <div class="stat-value">{{ number_format($purchases, 2) }}</div>
                <div class="stat-label">{{ __('Cost of Sales / Purchases') }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card pink h-100">
                <div class="stat-icon"><i class="fas fa-file-invoice-dollar"></i></div>
                <div class="stat-value">{{ number_format($totalOperatingExpenses, 2) }}</div>
                <div class="stat-label">{{ __('Operating Expenses') }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card {{ $netProfit >= 0 ? 'cyan' : 'red' }} h-100">
                <div class="stat-icon"><i class="fas fa-chart-line"></i></div>
                <div class="stat-value">{{ number_format($netProfit, 2) }}</div>
                <div class="stat-label">{{ __('Net Profit') }}</div>
                <div class="stat-trend {{ $netProfit >= 0 ? 'up' : 'down' }}">
                    {{ $netProfit >= 0 ? __('Profitable') : __('Loss') }}
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <!-- Detailed Table -->
            <div class="card glass-card mb-4">
                <div class="card-header border-bottom border-light">
                    <h5 class="mb-0">{{ __('Profit & Loss Breakdown') }}</h5>
                </div>
                <div class="card-body p-0">
                    <table class="table table-borderless mb-0">
                        <thead class="bg-black text-muted small uppercase">
                            <tr>
                                <th>{{ __('Description') }}</th>
                                <th class="text-end">{{ __('Amount') }} (EGP)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="border-bottom border-light">
                                <td class="fw-bold text-success"><i
                                        class="fas fa-plus-circle me-2"></i>{{ __('Total Revenue') }} (Invoices)</td>
                                <td class="text-end fw-bold text-success">{{ number_format($revenue, 2) }}</td>
                            </tr>
                            <tr class="border-bottom border-light">
                                <td class="fw-bold text-warning"><i
                                        class="fas fa-minus-circle me-2"></i>{{ __('Cost of Sales / Purchases') }} (Bills)
                                </td>
                                <td class="text-end fw-bold text-warning">{{ number_format($purchases, 2) }}</td>
                            </tr>
                            <tr class="bg-black">
                                <td class="fw-bold">{{ __('GROSS PROFIT') }}</td>
                                <td class="text-end fw-bold">{{ number_format($grossProfit, 2) }}</td>
                            </tr>

                            <tr>
                                <td colspan="2" class="py-3 text-muted small uppercase fw-bold">
                                    {{ __('Operating Expenses') }}</td>
                            </tr>

                            @foreach($expenseCategories as $category)
                                <tr class="border-bottom border-light opacity-75">
                                    <td class="ps-4 text-info">{{ $category->name }}</td>
                                    <td class="text-end text-info">{{ number_format($category->total_amount, 2) }}</td>
                                </tr>
                            @endforeach

                            <tr class="bg-black">
                                <td class="fw-bold">{{ __('NET PROFIT') }}</td>
                                <td class="text-end fw-bold fs-5 {{ $netProfit >= 0 ? 'text-cyan' : 'text-danger' }}">
                                    {{ number_format($netProfit, 2) }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Chart Section -->
            <div class="card glass-card">
                <div class="card-header border-bottom border-light py-3">
                    <h5 class="mb-0">{{ __('Income vs Expenses Chart') }}</h5>
                </div>
                <div class="card-body">
                    <canvas id="plChart" height="250"></canvas>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                var ctx = document.getElementById('plChart').getContext('2d');
                var plChart = new Chart(ctx, {
                    type: 'doughnut',
                    data: {
                        labels: ['{{ __('Total Revenue') }}', '{{ __('Cost of Sales') }}', '{{ __('Operating Expenses') }}'],
                        datasets: [{
                            data: [{{ $revenue }}, {{ $purchases }}, {{ $totalOperatingExpenses }}],
                            backgroundColor: [
                                'rgba(16, 185, 129, 0.7)', // Green
                                'rgba(249, 115, 22, 0.7)',  // Orange
                                'rgba(236, 72, 153, 0.7)',  // Pink
                            ],
                            borderColor: [
                                'rgba(16, 185, 129, 1)',
                                'rgba(249, 115, 22, 1)',
                                'rgba(236, 72, 153, 1)',
                            ],
                            borderWidth: 2,
                            hoverOffset: 15
                        }]
                    },
                    options: {
                        responsive: true,
                        cutout: '70%',
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: { color: '#94a3b8', padding: 20 }
                            },
                        }
                    }
                });
            });
        </script>
    @endpush
@endsection