@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="page-header d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="page-title">{{ __('Sales & Revenue Analysis') }}</h1>
                <p class="page-subtitle">{{ __('Performance metrics and customer growth insights') }}</p>
            </div>
            <form action="{{ route('accounting.reports.sales_analysis') }}" method="GET" class="d-flex gap-2">
                <input type="date" name="start_date" class="form-control" value="{{ $startDate }}" required>
                <input type="date" name="end_date" class="form-control" value="{{ $endDate }}" required>
                <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-2"></i>{{ __('Filter') }}</button>
                <a href="{{ route('accounting.reports.index') }}" class="btn btn-outline-light">{{ __('Back to Hub') }}</a>
            </form>
        </div>

        <!-- Stats Cards -->
        <div class="row g-4 mb-4">
            <div class="col-md-3">
                <div class="stat-card green">
                    <div class="stat-icon"><i class="fas fa-money-check-alt"></i></div>
                    <div class="stat-value">{{ number_format($revenue, 2) }}</div>
                    <div class="stat-label">{{ __('Total Revenue') }}</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card blue">
                    <div class="stat-icon"><i class="fas fa-file-invoice"></i></div>
                    <div class="stat-value">{{ $invoiceCount }}</div>
                    <div class="stat-label">{{ __('Total Invoices') }}</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card purple">
                    <div class="stat-icon"><i class="fas fa-calculator"></i></div>
                    <div class="stat-value">{{ number_format($avgInvoice, 2) }}</div>
                    <div class="stat-label">{{ __('Average Invoice Value') }}</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card cyan">
                    <div class="stat-icon"><i class="fas fa-user-plus"></i></div>
                    <div class="stat-value">{{ $newCustomers }}</div>
                    <div class="stat-label">{{ __('New Customers') }}</div>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <!-- Top Customers -->
            <div class="col-lg-6">
                <div class="card glass-card h-100">
                    <div class="card-header border-bottom border-light py-3">
                        <h5 class="mb-0 fw-bold">{{ __('Top 10 Customers') }}</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="bg-black text-muted small uppercase">
                                    <tr>
                                        <th>{{ __('Customer') }}</th>
                                        <th class="text-end">{{ __('Total Spent') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($topCustomers as $customer)
                                        <tr>
                                            <td>{{ $customer->name }}</td>
                                            <td class="text-end fw-bold text-success">
                                                {{ number_format($customer->total_spent, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Salesperson Performance -->
            <div class="col-lg-6">
                <div class="card glass-card h-100">
                    <div class="card-header border-bottom border-light py-3">
                        <h5 class="mb-0 fw-bold">{{ __('Salesperson Performance') }}</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="bg-black text-muted small uppercase">
                                    <tr>
                                        <th>{{ __('Salesperson') }}</th>
                                        <th class="text-end">{{ __('Total Sales') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($salesPerformance as $person)
                                        <tr>
                                            <td>{{ $person->name }}</td>
                                            <td class="text-end fw-bold text-primary">
                                                {{ number_format($person->total_sales, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection