@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Treasury Balances') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('accounting.reports.index') }}">{{ __('Reports') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Treasury Balance') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-primary text-white">
                <div class="card-body text-center p-4">
                    <h5 class="text-uppercase opacity-75">{{ __('Total Liquidity') }}</h5>
                    <h1 class="display-3 fw-bold mb-0">{{ number_format($totalBalance, 2) }} <small class="fs-4">{{ __('EGP') }}</small>
                    </h1>
                    <p class="mb-0">{{ __('Across all safes, banks, and wallets.') }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-dark border-secondary d-flex justify-content-between align-items-center">
            <h5 class="mb-0">{{ __('Detailed Breakdown') }}</h5>
            <button onclick="window.print()" class="btn btn-sm btn-outline-light"><i class="fas fa-print"></i>
                {{ __('Print') }}</button>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Treasury Name') }}</th>
                            <th>{{ __('Type') }}</th>
                            <th class="text-center">{{ __('Total Transactions') }}</th>
                            <th class="text-end">{{ __('Current Balance') }}</th>
                            <th class="text-end">{{ __('Status') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($treasuries as $treasury)
                            <tr>
                                <td class="fw-bold">{{ $treasury->name }}</td>
                                <td>
                                    @if($treasury->type == 'cash')
                                        <i class="fas fa-money-bill-wave text-success me-2"></i> {{ __('Cash Safe') }}
                                    @elseif($treasury->type == 'bank')
                                        <i class="fas fa-university text-primary me-2"></i> {{ __('Bank Account') }}
                                    @else
                                        <i class="fas fa-wallet text-warning me-2"></i> {{ __('Digital Wallet') }}
                                    @endif
                                </td>
                                <td class="text-center">{{ $treasury->transactions_count }}</td>
                                <td class="text-end fw-bold">{{ number_format($treasury->balance, 2) }}
                                    {{ $treasury->currency }}</td>
                                <td class="text-end">
                                    <a href="{{ route('accounting.treasuries.show', $treasury) }}"
                                        class="btn btn-sm btn-outline-secondary">{{ __('View History') }}</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot class="table-group-divider">
                        <tr class="table-secondary">
                            <td colspan="3" class="text-end fw-bold">{{ __('TOTAL ASSETS:') }}</td>
                            <td class="text-end fw-bold text-primary">{{ number_format($totalBalance, 2) }} {{ __('EGP') }}</td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection