@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('VAT Return Report') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('accounting.reports.index') }}">{{ __('Reports') }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('VAT Return') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('accounting.reports.vat_return') }}" class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">{{ __('Start Date') }}</label>
                    <input type="date" name="start_date" class="form-control" value="{{ $startDate }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">{{ __('End Date') }}</label>
                    <input type="date" name="end_date" class="form-control" value="{{ $endDate }}">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">{{ __('Calculate VAT') }}</button>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4 mb-4">
            <div class="card border-0 bg-dark text-white shadow">
                <div class="card-body text-center">
                    <h5 class="text-info">{{ __('Output Tax (Sales)') }}</h5>
                    <h3>{{ number_format($outputTax, 2) }}</h3>
                    <small class="text-muted">{{ __('Collected from Customers') }}</small>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card border-0 bg-dark text-white shadow">
                <div class="card-body text-center">
                    <h5 class="text-warning">{{ __('Input Tax (Purchases)') }}</h5>
                    <h3>{{ number_format($inputTax, 2) }}</h3>
                    <small class="text-muted">{{ __('Paid to Suppliers') }}</small>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card border-0 bg-dark text-white shadow">
                <div class="card-body text-center">
                    <h5 class="{{ $netVat >= 0 ? 'text-danger' : 'text-success' }}">{{ __('Net VAT Payable') }}</h5>
                    <h2 class="{{ $netVat >= 0 ? 'text-danger' : 'text-success' }}">
                        {{ number_format($netVat, 2) }}
                    </h2>
                    <small class="text-muted">
                        @if($netVat >= 0)
                            {{ __('Amount due to Tax Authority') }}
                        @else
                            {{ __('Refundable / Credit') }}
                        @endif
                    </small>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-dark border-secondary">
            <h5 class="mb-0">{{ __('Tax Summary') }}</h5>
        </div>
        <div class="card-body">
            <table class="table table-striped">
                <tbody>
                    <tr>
                        <td>{{ __('Total Output VAT (Sales)') }}</td>
                        <td class="text-end fw-bold">{{ number_format($outputTax, 2) }}</td>
                    </tr>
                    <tr>
                        <td>{{ __('Total Input VAT (Expenses/Purchases)') }}</td>
                        <td class="text-end fw-bold">({{ number_format($inputTax, 2) }})</td>
                    </tr>
                    <tr class="fs-5">
                        <td><strong>{{ __('Total Payable / (Refundable)') }}</strong></td>
                        <td class="text-end fw-bold {{ $netVat >= 0 ? 'text-danger' : 'text-success' }}">
                            {{ number_format($netVat, 2) }}
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
@endsection