@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Edit Sales Person:') }} {{ $salesPerson->name }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a
                            href="{{ route('accounting.sales-people.index') }}">{{ __('Sales Team') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Edit') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-body">
            <form action="{{ route('accounting.sales-people.update', $salesPerson) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('Full Name') }}</label>
                        <input type="text" name="name" class="form-control" value="{{ old('name', $salesPerson->name) }}"
                            required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('Email') }}</label>
                        <input type="email" name="email" class="form-control"
                            value="{{ old('email', $salesPerson->email) }}">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('Phone') }}</label>
                        <input type="text" name="phone" class="form-control"
                            value="{{ old('phone', $salesPerson->phone) }}">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('WhatsApp Number') }}</label>
                        <input type="text" name="whatsapp" class="form-control"
                            value="{{ old('whatsapp', $salesPerson->whatsapp) }}">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label d-block">{{ __('Status') }}</label>
                        <div class="form-check form-switch mt-2">
                            <input type="hidden" name="is_active" value="0">
                            <input class="form-check-input" type="checkbox" name="is_active" value="1" {{ $salesPerson->is_active ? 'checked' : '' }}>
                            <label class="form-check-label">{{ __('Active') }}</label>
                        </div>
                    </div>
                </div>

                <div class="mt-4 d-flex justify-content-between">
                    <div>
                        <button type="submit" class="btn btn-primary">{{ __('Update Sales Person') }}</button>
                        <a href="{{ route('accounting.sales-people.index') }}"
                            class="btn btn-outline-light ms-2">{{ __('Cancel') }}</a>
                    </div>

                    <form action="{{ route('accounting.sales-people.destroy', $salesPerson) }}" method="POST"
                        onsubmit="return confirm('{{ __('Are you sure you want to delete this sales person?') }}')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-outline-danger">{{ __('Delete Sales Person') }}</button>
                    </form>
                </div>
            </form>
        </div>
    </div>
@endsection