@extends('layouts.print_a4')

@section('title', 'سند صرف عمولة - ' . $payment->salesPerson->name)
@section('doc_title', 'سند صرف عمولة (Disbursement Voucher)')

@section('content')
    <div class="doc-meta">
        <div>رقم السند: <strong>VCH-{{ str_pad($payment->id, 5, '0', STR_PAD_LEFT) }}</strong></div>
        <div>التاريخ: <strong>{{ $payment->date->format('Y-m-d') }}</strong></div>
    </div>

    <div style="margin: 20px 0; font-size: 18px; line-height: 2;">
        يصرف لـ السيد/ <strong>{{ $payment->salesPerson->name }}</strong>
        <br>
        مبلغ وقدره: <strong>{{ number_format($payment->amount, 2) }} ج.م</strong>
        <br>
        وذلك مقابل: <strong>{{ $payment->notes ?: 'صرف عمولات مبيعات' }}</strong>
        <br>
        طريقة الدفع: <strong>{{ $payment->payment_method == 'cash' ? 'نقداً' : 'تحويل' }}</strong>
        <br>
        مخصوماً من: <strong>{{ $payment->treasury->name }}</strong>
    </div>

    <div class="totals-section"
        style="width: 100%; border: 2px solid #000; padding: 10px; text-align: center; font-size: 20px;">
        إجمالي المبلغ المنصرف: <strong>{{ number_format($payment->amount, 2) }} جنيه مصري فقط لا غير</strong>
    </div>

    <div class="signature-section">
        <div class="signature-box">
            توقيع المستلم
            <div class="signature-line"></div>
        </div>
        <div class="signature-box">
            المحاسب
            <div class="signature-line"></div>
        </div>
        <div class="signature-box">
            المدير المالي
            <div class="signature-line"></div>
        </div>
    </div>
@endsection