@extends('layouts.print_a4')

@section('title', 'كشف حساب عمولات - ' . $salesPerson->name)
@section('doc_title', 'كشف حساب عمولات (Commissions Statement)')

@section('content')
    <div class="doc-meta">
        <div>مندوب المبيعات: <strong>{{ $salesPerson->name }}</strong></div>
        <div>تاريخ التقرير: <strong>{{ date('Y-m-d') }}</strong></div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>التاريخ</th>
                <th>البيان</th>
                <th>المديول / الفاتورة</th>
                <th>عمولة (له)</th>
                <th>مدفوع (عليه)</th>
                <th>الرصيد</th>
            </tr>
        </thead>
        <tbody>
            @php $runningBalance = 0; @endphp
            @foreach($salesPerson->commissions->concat($salesPerson->payments)->sortBy('created_at') as $item)
                @if($item instanceof \App\Models\SalesCommission)
                    @php $runningBalance += $item->amount; @endphp
                    <tr>
                        <td>{{ $item->created_at->format('Y-m-d') }}</td>
                        <td>استحقاق عمولة</td>
                        <td>فاتورة #{{ $item->invoice->code }}</td>
                        <td class="text-success">{{ number_format($item->amount, 2) }}</td>
                        <td>-</td>
                        <td>{{ number_format($runningBalance, 2) }}</td>
                    </tr>
                @else
                    @php $runningBalance -= $item->amount; @endphp
                    <tr>
                        <td>{{ $item->date->format('Y-m-d') }}</td>
                        <td>صرف نقدية (سند #{{ $item->id }})</td>
                        <td>{{ $item->treasury->name }}</td>
                        <td>-</td>
                        <td class="text-danger">{{ number_format($item->amount, 2) }}</td>
                        <td>{{ number_format($runningBalance, 2) }}</td>
                    </tr>
                @endif
            @endforeach
        </tbody>
    </table>

    <div class="totals-section">
        <table class="totals-table">
            <tr>
                <td>إجمالي المستحق:</td>
                <td style="text-align: left;">{{ number_format($salesPerson->commissions->sum('amount'), 2) }}</td>
            </tr>
            <tr>
                <td>إجمالي المدفوع:</td>
                <td style="text-align: left;">{{ number_format($salesPerson->payments->sum('amount'), 2) }}</td>
            </tr>
            <tr class="total-row">
                <td>الرصيد المتبقي:</td>
                <td style="text-align: left;">{{ number_format($salesPerson->balance, 2) }} ج.م</td>
            </tr>
        </table>
    </div>

    <div class="signature-section">
        <div class="signature-box">
            توقيع المندوب
            <div class="signature-line"></div>
        </div>
        <div class="signature-box">
            المدير المالي
            <div class="signature-line"></div>
        </div>
    </div>
@endsection