@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">{{ $salesPerson->name }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a
                            href="{{ route('accounting.sales-people.index') }}">{{ __('Sales Team') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Financial Statement') }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="{{ route('accounting.sales-people.print-statement', $salesPerson) }}" target="_blank"
                class="btn btn-outline-light me-2">
                <i class="fas fa-print me-2"></i>{{ __('Print Statement') }}
            </a>
            <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#paymentModal">
                <i class="fas fa-money-bill-wave me-2"></i>{{ __('Record Payment') }}
            </button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3">
            <div class="card bg-primary text-white mb-4">
                <div class="card-body">
                    <h6 class="text-uppercase small">{{ __('Total Commissions') }}</h6>
                    <h3 class="fw-bold mb-0">{{ number_format($salesPerson->commissions->sum('amount'), 2) }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white mb-4">
                <div class="card-body">
                    <h6 class="text-uppercase small">{{ __('Total Paid') }}</h6>
                    <h3 class="fw-bold mb-0">{{ number_format($salesPerson->payments->sum('amount'), 2) }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger text-white mb-4">
                <div class="card-body">
                    <h6 class="text-uppercase small">{{ __('Pending Balance') }}</h6>
                    <h3 class="fw-bold mb-0">{{ number_format($salesPerson->balance, 2) }}</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between">
            <h5 class="mb-0">{{ __('Commission History') }}</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('Invoice') }}</th>
                            <th>{{ __('Customer') }}</th>
                            <th>{{ __('Amount') }}</th>
                            <th>{{ __('Status') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($salesPerson->commissions as $comm)
                            <tr>
                                <td>{{ $comm->created_at->format('Y-m-d') }}</td>
                                <td><a
                                        href="{{ route('accounting.invoices.show', $comm->invoice) }}">#{{ $comm->invoice->code }}</a>
                                </td>
                                <td>{{ $comm->invoice->customer->name }}</td>
                                <td class="fw-bold">{{ number_format($comm->amount, 2) }}</td>
                                <td>
                                    <span
                                        class="badge bg-{{ $comm->status == 'paid' ? 'success' : ($comm->status == 'partial' ? 'warning' : 'danger') }}">
                                        {{ __(ucfirst($comm->status)) }}
                                    </span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">{{ __('Payment History') }}</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('Amount') }}</th>
                            <th>{{ __('Treasury') }}</th>
                            <th>{{ __('Notes') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($salesPerson->payments as $payment)
                            <tr>
                                <td>{{ $payment->date->format('Y-m-d') }}</td>
                                <td class="fw-bold text-success">{{ number_format($payment->amount, 2) }}</td>
                                <td>{{ $payment->treasury->name }}</td>
                                <td>{{ $payment->notes }}</td>
                                <td>
                                    <a href="{{ route('accounting.commission-payments.print', $payment) }}" target="_blank"
                                        class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-print"></i>
                                    </a>
                                    <form action="{{ route('accounting.commission-payments.destroy', $payment) }}" method="POST"
                                        class="d-inline"
                                        onsubmit="return confirm('{{ __('Are you sure you want to reverse this payment?') }}')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Payment Modal -->
    <div class="modal fade" id="paymentModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="{{ route('accounting.sales-people.payment', $salesPerson) }}" method="POST">
                @csrf
                <div class="modal-content bg-dark border-secondary">
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title">{{ __('Record Commission Payment') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info">
                            {{ __('Current Outstanding Balance:') }} <strong>{{ number_format($salesPerson->balance, 2) }}
                                EGP</strong>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Payment Amount') }}</label>
                            <input type="number" name="amount" class="form-control" step="0.01"
                                max="{{ $salesPerson->balance }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Date') }}</label>
                            <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Deduct From Treasury') }}</label>
                            <select name="treasury_id" class="form-select" required>
                                @foreach($treasuries as $treasury)
                                    <option value="{{ $treasury->id }}">{{ $treasury->name }} (Bal:
                                        {{ number_format($treasury->balance, 2) }})
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Notes') }}</label>
                            <textarea name="notes" class="form-control" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Process Payment') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection