@extends('layouts.app')

@section('content')
    <!-- Page Header -->
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title">{{ __('Accounting Settings') }}</h1>
            <p class="page-subtitle">{{ __('Manage your financial structure, treasuries, and categories') }}</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('accounting.reports.index') }}" class="btn btn-outline-light">
                <i class="fas fa-chart-line me-2"></i>{{ __('Reports') }}
            </a>
            <a href="{{ route('accounting.invoices.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>{{ __('New Invoice') }}
            </a>
        </div>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-pills mb-4" id="accountingSettingsTabs" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" id="categories-tab" data-bs-toggle="tab" data-bs-target="#categories-content"
                type="button" role="tab">
                <i class="fas fa-tags me-2"></i>{{ __('Categories') }}
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" id="treasuries-tab" data-bs-toggle="tab" data-bs-target="#treasuries-content"
                type="button" role="tab">
                <i class="fas fa-vault me-2"></i>{{ __('Treasuries') }}
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" id="closing-tab" data-bs-toggle="tab" data-bs-target="#closing-content"
                type="button" role="tab">
                <i class="fas fa-lock me-2"></i>{{ __('Period Closing') }}
            </button>
        </li>
    </ul>

    <div class="tab-content" id="accountingSettingsContent">
        <!-- Categories Tab -->
        <div class="tab-pane fade show active" id="categories-content" role="tabpanel">
            <div class="row">
                <!-- Income Categories -->
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-success"><i
                                    class="fas fa-arrow-down me-2"></i>{{ __('Income Categories') }}</h5>
                            <button class="btn btn-sm btn-success" data-bs-toggle="modal"
                                data-bs-target="#createCategoryModal" onclick="setCategoryType('income')">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover align-middle">
                                    <thead>
                                        <tr>
                                            <th>{{ __('Name') }}</th>
                                            <th>{{ __('Description') }}</th>
                                            <th class="text-end">{{ __('Actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($incomeCategories as $category)
                                            <tr>
                                                <td class="fw-bold">{{ $category->name }}</td>
                                                <td class="text-muted small">
                                                    {{ \Illuminate\Support\Str::limit($category->description, 30) }}</td>
                                                <td class="text-end">
                                                    <button class="btn btn-sm btn-link text-info" data-bs-toggle="modal"
                                                        data-bs-target="#editCategoryModal{{ $category->id }}">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <form action="{{ route('accounting.categories.destroy', $category) }}"
                                                        method="POST" class="d-inline-block">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-link text-danger"
                                                            onclick="return confirm('{{ __('Are you sure?') }}')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>

                                            <!-- Edit Modal -->
                                            <div class="modal fade" id="editCategoryModal{{ $category->id }}" tabindex="-1">
                                                <div class="modal-dialog">
                                                    <form action="{{ route('accounting.categories.update', $category) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="modal-content bg-dark">
                                                            <div class="modal-header border-secondary">
                                                                <h5 class="modal-title">{{ __('Edit Category') }}</h5>
                                                                <button type="button" class="btn-close btn-close-white"
                                                                    data-bs-dismiss="modal"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="mb-3">
                                                                    <label class="form-label">{{ __('Name') }}</label>
                                                                    <input type="text" name="name" class="form-control"
                                                                        value="{{ $category->name }}" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label class="form-label">{{ __('Description') }}</label>
                                                                    <textarea name="description"
                                                                        class="form-control">{{ $category->description }}</textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer border-secondary">
                                                                <button type="button" class="btn btn-secondary"
                                                                    data-bs-dismiss="modal">{{ __('Close') }}</button>
                                                                <button type="submit"
                                                                    class="btn btn-primary">{{ __('Save Changes') }}</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        @empty
                                            <tr>
                                                <td colspan="3" class="text-center text-muted py-3">
                                                    {{ __('No income categories found.') }}</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Expense Categories -->
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-danger"><i class="fas fa-arrow-up me-2"></i>{{ __('Expense Categories') }}
                            </h5>
                            <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                data-bs-target="#createCategoryModal" onclick="setCategoryType('expense')">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover align-middle">
                                    <thead>
                                        <tr>
                                            <th>{{ __('Name') }}</th>
                                            <th>{{ __('Description') }}</th>
                                            <th class="text-end">{{ __('Actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($expenseCategories as $category)
                                            <tr>
                                                <td class="fw-bold">{{ $category->name }}</td>
                                                <td class="text-muted small">
                                                    {{ \Illuminate\Support\Str::limit($category->description, 30) }}</td>
                                                <td class="text-end">
                                                    <button class="btn btn-sm btn-link text-info" data-bs-toggle="modal"
                                                        data-bs-target="#editCategoryModal{{ $category->id }}">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <form action="{{ route('accounting.categories.destroy', $category) }}"
                                                        method="POST" class="d-inline-block">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-link text-danger"
                                                            onclick="return confirm('{{ __('Are you sure?') }}')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>

                                            <!-- Edit Modal -->
                                            <div class="modal fade" id="editCategoryModal{{ $category->id }}" tabindex="-1">
                                                <div class="modal-dialog">
                                                    <form action="{{ route('accounting.categories.update', $category) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="modal-content bg-dark">
                                                            <div class="modal-header border-secondary">
                                                                <h5 class="modal-title">{{ __('Edit Category') }}</h5>
                                                                <button type="button" class="btn-close btn-close-white"
                                                                    data-bs-dismiss="modal"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="mb-3">
                                                                    <label class="form-label">{{ __('Name') }}</label>
                                                                    <input type="text" name="name" class="form-control"
                                                                        value="{{ $category->name }}" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label class="form-label">{{ __('Description') }}</label>
                                                                    <textarea name="description"
                                                                        class="form-control">{{ $category->description }}</textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer border-secondary">
                                                                <button type="button" class="btn btn-secondary"
                                                                    data-bs-dismiss="modal">{{ __('Close') }}</button>
                                                                <button type="submit"
                                                                    class="btn btn-primary">{{ __('Save Changes') }}</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        @empty
                                            <tr>
                                                <td colspan="3" class="text-center text-muted py-3">
                                                    {{ __('No expense categories found.') }}</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Treasuries Tab -->
        <div class="tab-pane fade" id="treasuries-content" role="tabpanel">
            @include('accounting.treasuries._list', ['treasuries' => $treasuries])
        </div>

        <!-- Closing Tab -->
        <div class="tab-pane fade" id="closing-content" role="tabpanel">
            <div class="card glass-card">
                <div class="card-header">
                    <h5 class="mb-0 text-white"><i class="fas fa-calendar-times me-2"></i>{{ __('Monthly Closing & Period Locking') }}</h5>
                </div>
                <div class="card-body py-5">
                    <div class="row justify-content-center text-center">
                        <div class="col-md-6">
                            <div class="alert alert-info border-0 mb-4">
                                <i class="fas fa-info-circle me-2"></i>
                                {{ __('Locking a period prevents any additions, modifications, or deletions of transactions on or before the selected date.') }}
                            </div>

                            <form action="{{ route('accounting.settings.closing') }}" method="POST">
                                @csrf
                                <div class="mb-4">
                                    <label class="form-label text-muted fw-bold text-uppercase small">{{ __('Current Lock Date') }}</label>
                                    <div class="h3 text-white mb-3">
                                        {{ \App\Models\Setting::getValue('general', 'accounting_lock_date', __('None')) }}
                                    </div>
                                    <input type="date" name="lock_date" class="form-control form-control-lg text-center mx-auto" style="max-width: 300px;" 
                                        value="{{ \App\Models\Setting::getValue('general', 'accounting_lock_date', '') }}">
                                </div>
                                <button type="submit" class="btn btn-primary btn-lg px-5">
                                    <i class="fas fa-save me-2"></i>{{ __('Update Lock Date') }}
                                </button>
                            </form>

                            <div class="mt-4 p-3 rounded-3 bg-danger bg-opacity-10 border border-danger border-opacity-25 text-danger small">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                {{ __('Be careful: once locked, data becomes immutable for all users.') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Category Modal -->
    <div class="modal fade" id="createCategoryModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="{{ route('accounting.categories.store') }}" method="POST">
                @csrf
                <div class="modal-content bg-dark">
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title">{{ __('Create New Category') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="type" id="categoryTypeInput" value="income">
                        <div class="mb-3">
                            <label class="form-label">{{ __('Name') }} <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control"
                                placeholder="{{ __('e.g. Hosting Fees, Salaries') }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Description') }}</label>
                            <textarea name="description" class="form-control" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Create Category') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    @push('scripts')
        <script>
            function setCategoryType(type) {
                document.getElementById('categoryTypeInput').value = type;
                document.querySelector('#createCategoryModal .modal-title').textContent = type === 'income' ? '{{ __('Create Income Category') }}' : '{{ __('Create Expense Category') }}';
            }
        </script>
    @endpush
@endsection