@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('New Investor') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a
                            href="{{ route('accounting.shares.index') }}">{{ __('Shares Dashboard') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('New Investor') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card bg-dark border-secondary">
                <div class="card-header border-secondary bg-secondary text-white">{{ __('Investor') }} {{ __('Details') }}
                </div>
                <div class="card-body">
                    <form action="{{ route('accounting.shares.investors.store') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">{{ __('Name') }}</label>
                            <input type="text" name="name" class="form-control" placeholder="{{ __('Full Name') }}"
                                required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Email') }}</label>
                            <input type="email" name="email" class="form-control" placeholder="investor@example.com">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Phone') }}</label>
                            <input type="text" name="phone" class="form-control" placeholder="{{ __('WhatsApp Number') }}">
                        </div>
                        <button type="submit" class="btn btn-primary">{{ __('Create') }}</button>
                        <a href="{{ route('accounting.shares.index') }}"
                            class="btn btn-outline-light ms-2">{{ __('Cancel') }}</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection