@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">{{ __('Investors & Shares') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Shares Dashboard') }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <a href="{{ route('accounting.shares.investors.create') }}" class="btn btn-outline-info">
                <i class="fas fa-user-plus me-2"></i>{{ __('New Investor') }}
            </a>
            <button type="button" class="btn btn-primary ms-2" data-bs-toggle="modal" data-bs-target="#buySharesModal">
                <i class="fas fa-shopping-cart me-2"></i>{{ __('Buy Shares') }}
            </button>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-dark border-secondary">
                <div class="card-body text-center py-4">
                    <div class="text-secondary small fw-bold mb-1">{{ __('CURRENT SHARE PRICE') }}</div>
                    <h2 class="text-success mb-0">{{ number_format($currentSharePrice, 2) }} EGP</h2>
                    <div class="small text-muted mt-2">{{ __('Based on annual performance') }}</div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark border-secondary text-white">
                <div class="card-body text-center py-4">
                    <div class="text-secondary small fw-bold mb-1">{{ __('TOTAL SHARES') }}</div>
                    <h2 class="mb-0">{{ number_format($totalCompanyShares) }}</h2>
                    <div class="small text-muted mt-2">{{ __('Company capitalization') }}</div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark border-secondary text-white">
                <div class="card-body text-center py-4">
                    <div class="text-secondary small fw-bold mb-1">{{ __('SOLD SHARES') }}</div>
                    <h2 class="text-primary mb-0">{{ number_format($soldShares) }}</h2>
                    <div class="small text-muted mt-2">{{ number_format(($soldShares / $totalCompanyShares) * 100, 1) }}%
                        {{ __('of total') }}
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark border-secondary text-white">
                <div class="card-body text-center py-4">
                    <div class="text-secondary small fw-bold mb-1">{{ __('AVAILABLE SHARES') }}</div>
                    <h2 class="text-info mb-0">{{ number_format($availableShares) }}</h2>
                    <div class="small text-muted mt-2">{{ __('Ready for purchase') }}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div
            class="card-header bg-transparent border-secondary text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0">{{ __('Investor List') }}</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Investor') }}</th>
                            <th>{{ __('Shares Owned') }}</th>
                            <th>{{ __('Investment') }}</th>
                            <th>{{ __('Avg. Cost') }}</th>
                            <th>{{ __('Current Value') }}</th>
                            <th>{{ __('P/L') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($investors as $investor)
                            @php
                                $currentValue = $investor->total_shares * $currentSharePrice;
                                $profit = $currentValue - $investor->total_investment;
                                $profitPercent = $investor->total_investment > 0 ? ($profit / $investor->total_investment) * 100 : 0;
                            @endphp
                            <tr>
                                <td>
                                    <div class="fw-bold">{{ $investor->name }}</div>
                                    <div class="small text-muted">{{ $investor->phone ?? $investor->email }}</div>
                                </td>
                                <td>{{ number_format($investor->total_shares) }} {{ __('Units') }}</td>
                                <td>{{ number_format($investor->total_investment, 2) }} EGP</td>
                                <td>{{ number_format($investor->avg_purchase_price, 2) }} EGP</td>
                                <td class="fw-bold">{{ number_format($currentValue, 2) }} EGP</td>
                                <td>
                                    <span class="text-{{ $profit >= 0 ? 'success' : 'danger' }}">
                                        {{ $profit >= 0 ? '+' : '' }}{{ number_format($profit, 2) }}
                                        ({{ number_format($profitPercent, 1) }}%)
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">{{ __('No investors found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Buy Shares Modal -->
    <div class="modal fade" id="buySharesModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark border-secondary text-white">
                <form action="{{ route('accounting.shares.buy') }}" method="POST">
                    @csrf
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title">{{ __('Record Share Purchase') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">{{ __('Investor') }}</label>
                            <select name="investor_id" class="form-select bg-dark text-white border-secondary" required>
                                <option value="">{{ __('Select Investor...') }}</option>
                                @foreach($investors as $investor)
                                    <option value="{{ $investor->id }}">{{ $investor->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Quantity') }}</label>
                                <input type="number" name="shares" class="form-control" min="1" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Price per Share') }}</label>
                                <input type="number" name="price_per_share" class="form-control" step="0.01"
                                    value="{{ $currentSharePrice }}" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Date') }}</label>
                            <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-outline-light"
                            data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Confirm Purchase') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection