@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">Create Subscription</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.subscriptions.index') }}">Subscriptions</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Create') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <form action="{{ route('accounting.subscriptions.store') }}" method="POST">
        @csrf
        <div class="card bg-dark border-secondary">
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Client <span class="text-danger">*</span></label>
                        <select name="customer_id" class="form-select" required>
                            <option value="">Select Customer</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Service/Product Name <span class="text-danger">*</span></label>
                        <input type="text" name="service_name" class="form-control" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Price <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="price" class="form-control" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Currency <span class="text-danger">*</span></label>
                        <select name="currency" class="form-select" required>
                            <option value="EGP">EGP</option>
                            <option value="USD">USD</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Billing Cycle <span class="text-danger">*</span></label>
                        <select name="billing_cycle" class="form-select" required>
                            <option value="Monthly">Monthly</option>
                            <option value="Quarterly">Quarterly</option>
                            <option value="Semi-Annually">Semi-Annually</option>
                            <option value="Annually">Annually</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Start Date</label>
                        <input type="date" name="start_date" class="form-control">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Next Due Date</label>
                        <input type="date" name="next_due_date" class="form-control">
                    </div>
                </div>

                <div class="mt-4 text-end">
                    <a href="{{ route('accounting.subscriptions.index') }}" class="btn btn-secondary me-2">Cancel</a>
                    <button type="submit" class="btn btn-primary">Create Subscription</button>
                </div>
            </div>
        </div>
    </form>
@endsection