@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">Edit Subscription</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.subscriptions.index') }}">Subscriptions</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit</li>
                </ol>
            </nav>
        </div>
    </div>

    <form action="{{ route('accounting.subscriptions.update', $subscription->id) }}" method="POST" id="editForm">
        @method('PUT')
        @csrf
        <div class="card bg-dark border-secondary">
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Client <span class="text-danger">*</span></label>
                        <select name="customer_id" class="form-select" required>
                            <option value="">Select Customer</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ $subscription->customer_id == $customer->id ? 'selected' : '' }}>
                                    {{ $customer->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Service/Product Name <span class="text-danger">*</span></label>
                        <input type="text" name="service_name" class="form-control" value="{{ $subscription->service_name }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Price <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="price" class="form-control" value="{{ $subscription->price }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Currency <span class="text-danger">*</span></label>
                        <select name="currency" class="form-select" required>
                            <option value="EGP" {{ $subscription->currency == 'EGP' ? 'selected' : '' }}>EGP</option>
                            <option value="USD" {{ $subscription->currency == 'USD' ? 'selected' : '' }}>USD</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Billing Cycle <span class="text-danger">*</span></label>
                        <select name="billing_cycle" class="form-select" required>
                            <option value="Monthly" {{ $subscription->billing_cycle == 'Monthly' ? 'selected' : '' }}>Monthly</option>
                            <option value="Quarterly" {{ $subscription->billing_cycle == 'Quarterly' ? 'selected' : '' }}>Quarterly</option>
                            <option value="Semi-Annually" {{ $subscription->billing_cycle == 'Semi-Annually' ? 'selected' : '' }}>Semi-Annually</option>
                            <option value="Annually" {{ $subscription->billing_cycle == 'Annually' ? 'selected' : '' }}>Annually</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Start Date</label>
                        <input type="date" name="start_date" class="form-control" value="{{ $subscription->start_date?->format('Y-m-d') }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Next Due Date</label>
                        <input type="date" name="next_due_date" class="form-control" value="{{ $subscription->next_due_date?->format('Y-m-d') }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Status <span class="text-danger">*</span></label>
                        <select name="status" class="form-select" required>
                            <option value="active" {{ $subscription->status == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="suspended" {{ $subscription->status == 'suspended' ? 'selected' : '' }}>Suspended</option>
                            <option value="cancelled" {{ $subscription->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>
                </div>

                <div class="mt-4 text-end d-flex justify-content-between">
                    <button type="button" class="btn btn-outline-danger" onclick="document.getElementById('deleteForm').submit();">Delete</button>
                    <div>
                        <a href="{{ route('accounting.subscriptions.index') }}" class="btn btn-secondary me-2">Cancel</a>
                        <button type="submit" class="btn btn-primary">Update Subscription</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <form id="deleteForm" action="{{ route('accounting.subscriptions.destroy', $subscription->id) }}" method="POST" class="d-none" onsubmit="return confirm('Delete this subscription?');">
        @csrf
        @method('DELETE')
    </form>
@endsection
