@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <div>
                <h2 class="fw-light">{{ __('Subscriptions') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Subscriptions') }}</li>
                    </ol>
                </nav>
            </div>
            <div>
                <form action="{{ route('accounting.whmcs.sync-subscriptions') }}" method="POST" class="d-inline-block me-2">
                    @csrf
                    <button type="submit" class="btn btn-outline-success">
                        <i class="fas fa-sync me-2"></i>{{ __('Sync WHMCS') }}
                    </button>
                </form>
                <a href="{{ route('accounting.subscriptions.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>{{ __('New Subscription') }}
                </a>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-dark border-secondary">
            <h5 class="mb-0">{{ __('Active Subscriptions') }}</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Service/Product') }}</th>
                            <th>{{ __('Customer') }}</th>
                            <th>{{ __('Price') }}</th>
                            <th>{{ __('Billing Cycle') }}</th>
                            <th>{{ __('Next Due Date') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('WHMCS') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($subscriptions as $sub)
                            <tr>
                                <td data-label="{{ __('Service/Product') }}">
                                    <div class="fw-bold text-white">{{ $sub->service_name }}</div>
                                </td>
                                <td data-label="{{ __('Customer') }}">
                                    @if($sub->customer)
                                        <a href="{{ route('customers.show', $sub->customer_id) }}" class="text-decoration-none">
                                            {{ $sub->customer->name }}
                                        </a>
                                    @else
                                        <span class="text-muted">{{ __('Unknown') }}</span>
                                    @endif
                                </td>
                                <td data-label="{{ __('Price') }}">{{ number_format($sub->price, 2) }} {{ __($sub->currency) }}
                                </td>
                                <td data-label="{{ __('Billing Cycle') }}">{{ __($sub->billing_cycle) }}</td>
                                <td data-label="{{ __('Next Due Date') }}">
                                    @if($sub->next_due_date)
                                        <span class="{{ $sub->next_due_date->isPast() ? 'text-danger' : 'text-success' }}">
                                            {{ $sub->next_due_date->format('Y-m-d') }}
                                        </span>
                                    @else
                                        -
                                    @endif
                                </td>
                                <td data-label="{{ __('Status') }}">
                                    <span
                                        class="badge bg-{{ $sub->status === 'active' ? 'success' : ($sub->status === 'cancelled' ? 'danger' : 'warning') }}">
                                        {{ __($sub->status) }}
                                    </span>
                                </td>
                                <td data-label="{{ __('WHMCS') }}">
                                    @if($sub->whmcs_service_id)
                                        <span class="badge bg-info">{{ __('Linked') }}</span>
                                    @else
                                        <span class="badge bg-secondary">{{ __('Local') }}</span>
                                    @endif
                                </td>
                                <td data-label="{{ __('Actions') }}" class="text-end">
                                    <a href="{{ route('accounting.subscriptions.edit', $sub->id) }}"
                                        class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-4 text-muted">{{ __('No subscriptions found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center mt-3">
                {{ $subscriptions->links() }}
            </div>
        </div>
    </div>
@endsection