@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">{{ __('Supplier Services & Costs') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a
                            href="{{ route('accounting.suppliers.index') }}">{{ __('Suppliers') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Services') }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addServiceModal">
                <i class="fas fa-plus-circle me-2"></i>{{ __('Add New Service') }}
            </button>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Service Name') }}</th>
                            <th>{{ __('Supplier') }}</th>
                            <th>{{ __('Cost') }}</th>
                            <th>{{ __('Exchange Rate') }}</th>
                            <th>{{ __('Base Cost (EGP)') }}</th>
                            <th>{{ __('Markup / Margin') }}</th>
                            <th>{{ __('Suggested Sell') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($services as $service)
                            @php
                                $baseCurrency = \App\Models\Currency::getBase();
                                $baseCost = ($service->cost_price / $service->currency->exchange_rate) * $baseCurrency->exchange_rate;
                                $unitBaseCost = $service->type === 'reseller' ? $baseCost / ($service->reseller_units ?: 1) : $baseCost;

                                $sellPrice = 0;
                                if ($service->markup_type === 'percentage') {
                                    $sellPrice = $unitBaseCost + ($unitBaseCost * $service->markup_value / 100);
                                } else {
                                    $sellPrice = $unitBaseCost + $service->markup_value;
                                }
                            @endphp
                            <tr>
                                <td data-label="{{ __('Service Name') }}">
                                    <div class="fw-bold">{{ $service->name }}</div>
                                    <span class="badge bg-secondary small">{{ ucfirst($service->type) }}</span>
                                    @if($service->type === 'reseller')
                                        <small class="d-block text-muted">{{ $service->reseller_units }} Sites</small>
                                    @endif
                                </td>
                                <td data-label="{{ __('Supplier') }}">{{ $service->supplier->name }}</td>
                                <td data-label="{{ __('Cost') }}">
                                    {{ number_format($service->cost_price, 2) }} {{ $service->currency->symbol }}
                                </td>
                                <td data-label="{{ __('Exchange Rate') }}">
                                    @if(!$service->currency->is_base)
                                        <small class="text-muted">1 {{ $baseCurrency->code }} =
                                            {{ number_format($service->currency->exchange_rate, 2) }}
                                            {{ $service->currency->code }}</small>
                                    @else
                                        -
                                    @endif
                                </td>
                                <td data-label="{{ __('Base Cost (EGP)') }}" class="fw-bold">
                                    {{ number_format($baseCost, 2) }}
                                    @if($service->type === 'reseller')
                                        <div class="small text-muted">({{ number_format($unitBaseCost, 2) }} / unit)</div>
                                    @endif
                                </td>
                                <td data-label="{{ __('Markup / Margin') }}">
                                    @if($service->markup_type === 'percentage')
                                        <span class="text-success">+{{ $service->markup_value }}%</span>
                                    @else
                                        <span class="text-success">+{{ number_format($service->markup_value, 2) }} EGP</span>
                                    @endif
                                </td>
                                <td data-label="{{ __('Suggested Sell') }}" class="fw-bold text-info">
                                    {{ number_format($sellPrice, 2) }} EGP
                                </td>
                                <td data-label="{{ __('Actions') }}" class="text-end">
                                    <button class="btn btn-sm btn-outline-light" data-bs-toggle="modal"
                                        data-bs-target="#editServiceModal{{ $service->id }}">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-5 text-muted">{{ __('No services configured.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add Modal -->
    <div class="modal fade" id="addServiceModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content bg-dark border-secondary text-white">
                <form action="{{ route('accounting.supplier-services.store') }}" method="POST">
                    @csrf
                    <div class="modal-header border-secondary text-start">
                        <h5 class="modal-title">{{ __('Add Supplier Service') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-start">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Supplier') }}</label>
                                <select name="supplier_id" class="form-select bg-dark text-white border-secondary" required>
                                    @foreach($suppliers as $supplier)
                                        <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Service Type') }}</label>
                                <select name="type" id="service_type"
                                    class="form-select bg-dark text-white border-secondary" required>
                                    <option value="reseller">{{ __('Reseller Hosting') }}</option>
                                    <option value="server">{{ __('VPS / Dedicated Server') }}</option>
                                    <option value="domain">{{ __('Domain Name') }}</option>
                                    <option value="other">{{ __('Other Service') }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Service Name') }}</label>
                            <input type="text" name="name" class="form-control" placeholder="e.g. 100GB Reseller Plan"
                                required>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('Cost Price') }}</label>
                                <input type="number" name="cost_price" class="form-control" step="0.01" required>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">{{ __('Currency') }}</label>
                                <select name="currency_id" class="form-select bg-dark text-white border-secondary" required>
                                    @foreach($currencies as $currency)
                                        <option value="{{ $currency->id }}">{{ $currency->code }} ({{ $currency->symbol }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4 mb-3" id="reseller_units_group">
                                <label class="form-label">{{ __('Number of Sites/Units') }}</label>
                                <input type="number" name="reseller_units" class="form-control" value="1">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Markup Type') }}</label>
                                <select name="markup_type" class="form-select bg-dark text-white border-secondary">
                                    <option value="fixed">{{ __('Fixed Amount (EGP)') }}</option>
                                    <option value="percentage">{{ __('Percentage (%)') }}</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Markup Value') }}</label>
                                <input type="number" name="markup_value" class="form-control" step="0.01" value="0">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('internal Notes') }}</label>
                            <textarea name="notes" class="form-control" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-outline-light"
                            data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Create Service') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            document.getElementById('service_type').addEventListener('change', function () {
                const resellerGroup = document.getElementById('reseller_units_group');
                if (this.value === 'reseller') {
                    resellerGroup.style.display = 'block';
                } else {
                    resellerGroup.style.display = 'none';
                }
            });
        </script>
    @endpush
@endsection