@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Edit Supplier') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a
                            href="{{ route('accounting.suppliers.index') }}">{{ __('Suppliers') }}</a></li>
                    <li class="breadcrumb-item active">{{ $supplier->name }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('accounting.suppliers.update', $supplier) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="mb-3">
                            <label class="form-label">{{ __('Company / Name') }} <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" value="{{ $supplier->name }}" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Phone') }}</label>
                                <input type="text" name="phone" class="form-control" value="{{ $supplier->phone }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Email') }}</label>
                                <input type="email" name="email" class="form-control" value="{{ $supplier->email }}">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">{{ __('Tax ID (Registration No)') }}</label>
                            <input type="text" name="tax_id" class="form-control" value="{{ $supplier->tax_id }}">
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Currency') }}</label>
                                <select name="currency_id" class="form-select">
                                    <option value="">{{ __('Default (System Base)') }}</option>
                                    @foreach($currencies as $currency)
                                        <option value="{{ $currency->id }}" {{ $supplier->currency_id == $currency->id ? 'selected' : '' }}>
                                            {{ $currency->code }} - {{ $currency->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('Opening Balance') }}</label>
                                <input type="number" step="0.01" name="opening_balance" class="form-control"
                                    value="{{ $supplier->opening_balance }}">
                                <small class="text-muted">{{ __('Positive value means you owe the supplier.') }}</small>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">{{ __('Address') }}</label>
                            <textarea name="address" class="form-control" rows="2">{{ $supplier->address }}</textarea>
                        </div>

                        <div class="mb-3 form-check">
                            <input type="checkbox" name="is_active" class="form-check-input" id="isActive" {{ $supplier->is_active ? 'checked' : '' }} value="1">
                            <label class="form-check-label" for="isActive">{{ __('Active Supplier') }}</label>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                            <a href="{{ route('accounting.suppliers.index') }}"
                                class="btn btn-outline-secondary">{{ __('Cancel') }}</a>
                        </div>
                    </form>

                    <hr class="my-4">

                    <div class="text-center">
                        <form action="{{ route('accounting.suppliers.destroy', $supplier) }}" method="POST"
                            onsubmit="return confirm('{{ __('Are you sure? This will deactivate the supplier.') }}')">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-danger btn-sm">{{ __('Deactivate Supplier') }}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection