@extends('layouts.app')

@section('content')
    <!-- Page Header -->
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title">{{ __('Suppliers') }}</h1>
            <p class="page-subtitle">{{ __('Manage your vendors and track payable amounts') }}</p>
        </div>
        <a href="{{ route('accounting.suppliers.create') }}" class="btn btn-primary">
            <i class="fas fa-plus-circle me-2"></i>{{ __('New Supplier') }}
        </a>
    </div>

    <!-- Stats Row -->
    <div class="row g-4 mb-4">
        <div class="col-6 col-lg-3">
            <div class="stat-card orange">
                <div class="stat-icon"><i class="fas fa-truck"></i></div>
                <div class="stat-value">{{ $suppliers->total() }}</div>
                <div class="stat-label">{{ __('Total Suppliers') }}</div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="stat-card pink">
                <div class="stat-icon"><i class="fas fa-coins"></i></div>
                <div class="stat-value">{{ number_format($suppliers->sum(function ($s) {
        return $s->balance * ($s->currency->exchange_rate ?? 1);
    }), 2) }}</div>
                <div class="stat-label">{{ __('Total Payable (Base Currency)') }}</div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="stat-card green">
                <div class="stat-icon"><i class="fas fa-check-circle"></i></div>
                <div class="stat-value">{{ $suppliers->where('balance', 0)->count() }}</div>
                <div class="stat-label">{{ __('Settled') }}</div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="stat-card purple">
                <div class="stat-icon"><i class="fas fa-exclamation-triangle"></i></div>
                <div class="stat-value">{{ $suppliers->where('balance', '>', 0)->count() }}</div>
                <div class="stat-label">{{ __('With Balance') }}</div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Name') }}</th>
                            <th>{{ __('Mobile') }}</th>
                            <th>{{ __('Tax ID') }}</th>
                            <th>{{ __('Balance (Due)') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($suppliers as $supplier)
                            <tr>
                                <td data-label="{{ __('Name') }}" class="fw-bold">
                                    {{ $supplier->name }}
                                    @if($supplier->email)
                                        <br><small class="text-muted">{{ $supplier->email }}</small>
                                    @endif
                                </td>
                                <td data-label="{{ __('Mobile') }}">{{ $supplier->phone ?? '-' }}</td>
                                <td data-label="{{ __('Tax ID') }}">{{ $supplier->tax_id ?? '-' }}</td>
                                <td data-label="{{ __('Balance (Due)') }}" class="fw-bold text-danger">
                                    {{ number_format($supplier->balance, 2) }} {{ $supplier->currency->code ?? 'EGP' }}
                                </td>
                                <td data-label="{{ __('Actions') }}">
                                    <div class="d-flex gap-1">
                                        <a href="{{ route('accounting.suppliers.show', $supplier) }}"
                                            class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('accounting.suppliers.edit', $supplier) }}"
                                            class="btn btn-sm btn-outline-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-5">
                                    <i class="fas fa-truck fa-3x text-muted mb-3"></i>
                                    <h3>{{ __('No suppliers found') }}</h3>
                                    <p class="text-muted">{{ __('Register your vendors to track expenses.') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($suppliers->hasPages())
            <div class="card-footer">
                {{ $suppliers->links() }}
            </div>
        @endif
    </div>
@endsection