@extends('layouts.app')

@section('content')
    <div class="row mb-4 flex-wrap gap-3">
        <div class="col">
            <h2 class="fw-light mb-0">{{ __('Supplier Profile') }}: <span class="fw-bold">{{ $supplier->name }}</span></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a
                            href="{{ route('accounting.suppliers.index') }}">{{ __('Suppliers') }}</a></li>
                    <li class="breadcrumb-item active">{{ $supplier->name }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-auto d-flex gap-2">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPaymentModal">
                <i class="fas fa-plus-circle me-2"></i>{{ __('Add Advance Payment') }}
            </button>
            <a href="{{ route('accounting.suppliers.edit', $supplier) }}" class="btn btn-outline-warning">
                <i class="fas fa-edit me-2"></i>{{ __('Edit Details') }}
            </a>
        </div>
    </div>

    <!-- Stats Summary -->
    <div class="row g-4 mb-4">
        <div class="col-6 col-lg-3">
            <div class="card stat-card border-start border-4 border-primary">
                <div class="card-body">
                    <small class="text-muted d-block mb-1">{{ __('Total Due') }}</small>
                    <h3 class="mb-0 fw-bold text-danger">{{ number_format($supplier->total_due, 2) }} <small
                            class="fs-6">{{ $supplier->currency->code ?? 'EGP' }}</small></h3>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card border-start border-4 border-success">
                <div class="card-body">
                    <small class="text-muted d-block mb-1">{{ __('Advance Credit') }}</small>
                    <h3 class="mb-0 fw-bold text-success">{{ number_format($supplier->advance_balance, 2) }} <small
                            class="fs-6">{{ $supplier->currency->code ?? 'EGP' }}</small></h3>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card border-start border-4 border-info">
                <div class="card-body">
                    <small class="text-muted d-block mb-1">{{ __('Net Balance') }}</small>
                    <h3 class="mb-0 fw-bold {{ $supplier->net_balance > 0 ? 'text-danger' : 'text-primary' }}">
                        {{ number_format(abs($supplier->net_balance), 2) }}
                        <small class="fs-6">{{ $supplier->currency->code ?? 'EGP' }}</small>
                    </h3>
                    <small
                        class="text-muted small">{{ $supplier->net_balance > 0 ? __('You owe them') : __('They owe you / Credit') }}</small>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card border-start border-4 border-warning">
                <div class="card-body">
                    <small class="text-muted d-block mb-1">{{ __('Total Bills') }}</small>
                    <h3 class="mb-0 fw-bold">{{ $supplier->bills()->count() }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabs Container -->
    <div class="card">
        <div class="card-header bg-transparent border-bottom-0 pb-0">
            <ul class="nav nav-tabs card-header-tabs" id="supplierTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active py-3" id="bills-tab" data-bs-toggle="tab" data-bs-target="#bills"
                        type="button" role="tab">{{ __('Bills & Invoices') }}</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link py-3" id="transactions-tab" data-bs-toggle="tab" data-bs-target="#transactions"
                        type="button" role="tab">{{ __('Financial History') }}</button>
                </li>
            </ul>
        </div>
        <div class="card-body pt-4">
            <div class="tab-content" id="supplierTabsContent">
                <!-- Bills Tab -->
                <div class="tab-pane fade show active" id="bills" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-dark">
                                <tr>
                                    <th>{{ __('Bill Code') }}</th>
                                    <th>{{ __('Date') }}</th>
                                    <th>{{ __('Due Date') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th class="text-end">{{ __('Total') }}</th>
                                    <th class="text-end">{{ __('Paid') }}</th>
                                    <th class="text-end">{{ __('Remaining') }}</th>
                                    <th class="text-center">{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($bills as $bill)
                                    <tr>
                                        <td class="fw-bold">{{ $bill->code }}</td>
                                        <td>{{ $bill->date->format('Y-m-d') }}</td>
                                        <td>{{ $bill->due_date ? $bill->due_date->format('Y-m-d') : '-' }}</td>
                                        <td>
                                            @php
                                                $statusColors = ['paid' => 'success', 'unpaid' => 'danger', 'partial' => 'info', 'sent' => 'primary'];
                                                $color = $statusColors[$bill->status] ?? 'secondary';
                                            @endphp
                                            <span class="badge bg-{{ $color }}">{{ __($bill->status) }}</span>
                                        </td>
                                        <td class="text-end fw-bold">{{ number_format($bill->total, 2) }}</td>
                                        <td class="text-end text-success">{{ number_format($bill->paid_amount, 2) }}</td>
                                        <td class="text-end text-danger">
                                            {{ number_format($bill->total - $bill->paid_amount, 2) }}</td>
                                        <td class="text-center">
                                            <a href="{{ route('accounting.bills.show', $bill) }}"
                                                class="btn btn-sm btn-outline-light">
                                                <i class="fas fa-eye text-primary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center py-4 text-muted">
                                            {{ __('No bills found for this supplier.') }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        {{ $bills->appends(['trans_page' => $transactions->currentPage()])->links() }}
                    </div>
                </div>

                <!-- Transactions Tab -->
                <div class="tab-pane fade" id="transactions" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-dark">
                                <tr>
                                    <th>{{ __('Date') }}</th>
                                    <th>{{ __('Treasury') }}</th>
                                    <th>{{ __('Type') }}</th>
                                    <th>{{ __('Description') }}</th>
                                    <th class="text-end">{{ __('Amount') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transactions as $trans)
                                    <tr>
                                        <td>{{ $trans->date->format('Y-m-d') }}</td>
                                        <td>{{ $trans->treasury->name }}</td>
                                        <td>
                                            <span class="badge {{ $trans->type == 'income' ? 'bg-success' : 'bg-danger' }}">
                                                {{ __($trans->type) }}
                                            </span>
                                        </td>
                                        <td>{{ $trans->description }}</td>
                                        <td
                                            class="text-end fw-bold {{ $trans->type == 'income' ? 'text-success' : 'text-danger' }}">
                                            {{ $trans->type == 'income' ? '-' : '+' }} {{ number_format($trans->amount, 2) }}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center py-4 text-muted">
                                            {{ __('No financial history found.') }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        {{ $transactions->appends(['bills_page' => $bills->currentPage()])->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Payment Modal -->
    <div class="modal fade" id="addPaymentModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="{{ route('accounting.suppliers.payment', $supplier) }}" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('Add Advance Payment') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info py-2 small">
                            {{ __('This records money paid to the supplier that isn\'t yet linked to a specific bill.') }}
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">{{ __('Amount') }}
                                ({{ $supplier->currency->code ?? 'EGP' }})</label>
                            <input type="number" step="0.01" name="amount" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">{{ __('Treasury / Safe') }}</label>
                            <select name="treasury_id" class="form-select" required>
                                <option value="">{{ __('Select Treasury') }}</option>
                                @foreach($treasuries as $treasury)
                                    <option value="{{ $treasury->id }}">{{ $treasury->name }}
                                        ({{ number_format($treasury->balance, 2) }} {{ $treasury->currency->code ?? 'EGP' }})
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">{{ __('Date') }}</label>
                            <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">{{ __('Description / Reference') }}</label>
                            <textarea name="description" class="form-control" rows="2"
                                placeholder="{{ __('e.g. Advance for June stock') }}"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Record Payment') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection