@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">تذكرة رقم #{{ $ticket->whmcs_id }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">لوحة التحكم</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('accounting.tickets.index') }}">التذاكر</a></li>
                    <li class="breadcrumb-item"><a
                            href="{{ route('customers.show', $ticket->customer) }}">{{ $ticket->customer->name }}</a></li>
                    <li class="breadcrumb-item active">تفاصيل التذكرة</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card glass-card mb-4">
                <div class="card-header bg-transparent border-secondary">
                    <h5 class="mb-0">{{ $ticket->subject }}</h5>
                </div>
                <div class="card-body" style="max-height: 600px; overflow-y: auto;">
                    <div class="conversation">
                        @foreach($replies as $reply)
                            <div class="mb-4 {{ !empty($reply['admin']) ? 'text-end' : 'text-start' }}">
                                <div class="d-inline-block p-3 rounded shadow-sm {{ !empty($reply['admin']) ? 'bg-primary text-white ms-5' : 'bg-dark border border-secondary text-white me-5' }}"
                                    style="max-width: 80%;">
                                    <div class="small mb-1 opacity-75">
                                        <strong>{{ $reply['admin'] ?: $reply['requestorname'] ?: 'العميل' }}</strong>
                                        <span class="ms-2 small">{{ $reply['date'] }}</span>
                                    </div>
                                    <div class="message-content">
                                        {!! nl2br(e($reply['message'])) !!}
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="card-footer bg-transparent border-secondary py-3">
                    <form action="{{ route('accounting.tickets.reply', $ticket) }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label text-info">إضافة رد</label>
                            <textarea name="message" class="form-control bg-black text-white border-secondary" rows="4"
                                placeholder="اكتب ردك هنا..." required></textarea>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="text-muted small">
                                <i class="fab fa-whatsapp me-1 text-success"></i> سيتم إرسال إشعار للعميل عبر الواتساب.
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane me-2"></i>إرسال الرد
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card glass-card h-100">
                <div class="card-header bg-transparent border-secondary text-center py-4">
                    <i class="fas fa-ticket-alt fa-3x text-info mb-3"></i>
                    <h5 class="mb-0">معلومات التذكرة</h5>
                </div>
                <ul class="list-group list-group-flush small">
                    <li class="list-group-item bg-transparent text-white border-secondary d-flex justify-content-between">
                        <span class="text-muted">الحالة</span>
                        <span class="badge bg-info">{{ $ticket->status }}</span>
                    </li>
                    <li class="list-group-item bg-transparent text-white border-secondary d-flex justify-content-between">
                        <span class="text-muted">الأولوية</span>
                        <span>{{ $ticket->priority }}</span>
                    </li>
                    <li class="list-group-item bg-transparent text-white border-secondary d-flex justify-content-between">
                        <span class="text-muted">القسم</span>
                        <span>{{ $ticket->department }}</span>
                    </li>
                    <li class="list-group-item bg-transparent text-white border-secondary d-flex justify-content-between">
                        <span class="text-muted">آخر رد</span>
                        <span class="small">{{ $ticket->last_reply }}</span>
                    </li>
                </ul>
                <div class="card-body d-grid gap-2">
                    <a href="https://whmcs.yourdomain.com/admin/supporttickets.php?action=view&id={{ $ticket->whmcs_id }}"
                        target="_blank" class="btn btn-sm btn-outline-warning">
                        عرض في WHMCS <i class="fas fa-external-link-alt ms-1"></i>
                    </a>
                    <a href="{{ route('customers.show', $ticket->customer) }}" class="btn btn-sm btn-outline-light">
                        ملف العميل <i class="fas fa-user ms-1"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <style>
        .glass-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .conversation {
            display: flex;
            flex-direction: column;
        }

        /* RTL support improvements */
        body {
            direction: rtl;
        }

        .text-start {
            text-align: right !important;
        }

        .text-end {
            text-align: left !important;
        }

        .ms-5 {
            margin-right: 3rem !important;
            margin-left: 0 !important;
        }

        .me-5 {
            margin-left: 3rem !important;
            margin-right: 0 !important;
        }
    </style>
@endsection