@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">سجل المعاملات المالية</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">لوحة التحكم</a></li>
                    <li class="breadcrumb-item active">المعاملات المالية</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <form action="{{ route('accounting.transactions.index') }}" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label">الخزنة</label>
                    <select name="treasury_id" class="form-select">
                        <option value="">الكل</option>
                        @foreach($treasuries as $treasury)
                            <option value="{{ $treasury->id }}" {{ request('treasury_id') == $treasury->id ? 'selected' : '' }}>
                                {{ $treasury->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">بحث</button>
                </div>
            </form>
        </div>
    </div>

    <ul class="nav nav-tabs mb-3" id="transTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="treasury-tab" data-bs-toggle="tab" data-bs-target="#treasury" type="button"
                role="tab" aria-selected="true">
                <i class="fas fa-university me-2"></i>حركات الخزنة
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="wallet-tab" data-bs-toggle="tab" data-bs-target="#wallet" type="button" role="tab"
                aria-selected="false">
                <i class="fas fa-wallet me-2"></i>محافظ العملاء
            </button>
        </li>
    </ul>

    <div class="tab-content" id="transTabsContent">
        <!-- Treasury Tab -->
        <div class="tab-pane fade show active" id="treasury" role="tabpanel">
            <div class="card">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>التاريخ</th>
                                <th>النوع</th>
                                <th>المبلغ</th>
                                <th>الخزنة</th>
                                <th>الوصف</th>
                                <th>المستخدم</th>
                                <th>المرجع</th>
                                <th>الاجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($treasuryTransactions as $transaction)
                                <tr>
                                    <td>{{ $transaction->id }}</td>
                                    <td>{{ $transaction->date->format('Y-m-d') }}</td>
                                    <td>
                                        <span
                                            class="badge bg-{{ $transaction->type == 'in' ? 'success' : ($transaction->type == 'out' ? 'danger' : 'info') }}">
                                            {{ $transaction->type == 'in' ? 'إيراد' : ($transaction->type == 'out' ? 'مصروف' : 'أخرى') }}
                                        </span>
                                    </td>
                                    <td class="fw-bold {{ $transaction->type == 'income' ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($transaction->amount, 2) }}
                                    </td>
                                    <td>{{ $transaction->treasury->name ?? '-' }}</td>
                                    <td>{{ $transaction->description }}</td>
                                    <td>{{ $transaction->user->name ?? '-' }}</td>
                                    <td>
                                        @if($transaction->model_type == 'App\Models\Invoice')
                                            <a href="{{ route('accounting.invoices.show', $transaction->model_id) }}">فاتورة
                                                #{{ $transaction->model_id }}</a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td>
                                        <form action="{{ route('accounting.transactions.destroy', $transaction->id) }}"
                                            method="POST"
                                            onsubmit="return confirm('هل أنت متأكد من الحذف؟ سيتم استرجاع رصيد الخزنة.')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="text-center py-4 text-muted">لا توجد حركات</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    {{ $treasuryTransactions->links() }}
                </div>
            </div>
        </div>

        <!-- Wallet Tab -->
        <div class="tab-pane fade" id="wallet" role="tabpanel">
            <div class="card">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>التاريخ</th>
                                <th>العميل</th>
                                <th>النوع</th>
                                <th>المبلغ</th>
                                <th>الوصف</th>
                                <th>المستخدم</th>
                                <th>الاجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($walletTransactions as $transaction)
                                <tr>
                                    <td>{{ $transaction->id }}</td>
                                    <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        @if($transaction->customer)
                                            <a
                                                href="{{ route('customers.show', $transaction->customer_id) }}">{{ $transaction->customer->name }}</a>
                                        @else
                                            <span class="text-muted">عميل محذوف</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if(in_array($transaction->type, ['deposit', 'adjustment']) && $transaction->amount > 0)
                                            <span class="badge bg-success">إيداع</span>
                                        @else
                                            <span class="badge bg-danger">خصم</span>
                                        @endif
                                        <small class="text-muted">
                                            ({{ $transaction->type == 'deposit' ? 'إيداع' : ($transaction->type == 'adjustment' ? 'تسويه' : 'خصم') }})
                                        </small>
                                    </td>
                                    <td
                                        class="fw-bold {{ (in_array($transaction->type, ['deposit', 'adjustment']) && $transaction->amount > 0) ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($transaction->amount, 2) }}
                                    </td>
                                    <td>{{ $transaction->notes }}</td>
                                    <td>{{ $transaction->user->name ?? '-' }}</td>
                                    <td>
                                        <form
                                            action="{{ action([\App\Http\Controllers\CustomerController::class, 'destroyWalletTransaction'], ['customer' => $transaction->customer_id, 'transaction' => $transaction->id]) }}"
                                            method="POST" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4 text-muted">لا توجد حركات</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    {{ $walletTransactions->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection