<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
    <div>
        <h3 class="mb-0">{{ __('Treasuries & Banks') }}</h3>
        <p class="text-muted">{{ __('Manage cash safes, bank accounts, and digital wallets') }}</p>
    </div>
    <div class="d-flex gap-2">
        <button type="button" class="btn btn-outline-light" data-bs-toggle="modal" data-bs-target="#transferModal">
            <i class="fas fa-exchange-alt me-2"></i>{{ __('Transfer') }}
        </button>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createTreasuryModal">
            <i class="fas fa-plus-circle me-2"></i>{{ __('New Treasury') }}
        </button>
    </div>
</div>

<!-- Stats Row -->
<div class="row g-4 mb-4">
    <div class="col-6 col-lg-3">
        <div class="stat-card cyan">
            <div class="stat-icon"><i class="fas fa-vault"></i></div>
            <div class="stat-value">{{ $treasuries->count() }}</div>
            <div class="stat-label">{{ __('Total Treasuries') }}</div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="stat-card green">
            <div class="stat-icon"><i class="fas fa-coins"></i></div>
            <div class="stat-value">{{ number_format($treasuries->sum('balance'), 0) }}</div>
            <div class="stat-label">{{ __('Total Balance (EGP)') }}</div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="stat-card purple">
            <div class="stat-icon"><i class="fas fa-cash-register"></i></div>
            <div class="stat-value">{{ $treasuries->where('type', 'cash')->count() }}</div>
            <div class="stat-label">{{ __('Cash Safes') }}</div>
        </div>
    </div>
    <div class="col-6 col-lg-3">
        <div class="stat-card yellow">
            <div class="stat-icon"><i class="fas fa-university"></i></div>
            <div class="stat-value">{{ $treasuries->where('type', 'bank')->count() }}</div>
            <div class="stat-label">{{ __('Bank Accounts') }}</div>
        </div>
    </div>
</div>

<div class="row">
    @forelse($treasuries as $treasury)
        <div class="col-md-4 mb-4">
            <div
                class="card h-100 border-start border-4 {{ $treasury->type == 'cash' ? 'border-success' : ($treasury->type == 'bank' ? 'border-primary' : 'border-warning') }}">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <h5 class="card-title fw-bold">{{ $treasury->name }}</h5>
                            <span class="badge bg-secondary text-uppercase">{{ __($treasury->type) }}</span>
                        </div>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-link text-muted" type="button" data-bs-toggle="dropdown">
                                <i class="fas fa-ellipsis-v"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-dark">
                                <li><a class="dropdown-item"
                                        href="{{ route('accounting.treasuries.show', $treasury) }}">{{ __('View Transactions') }}</a>
                                </li>
                                <li><button class="dropdown-item" data-bs-toggle="modal"
                                        data-bs-target="#editTreasury{{ $treasury->id }}">{{ __('Edit') }}</button></li>
                            </ul>
                        </div>
                    </div>

                    <h3 class="mb-3">{{ number_format($treasury->balance, 2) }} <small
                            class="text-muted fs-6">{{ $treasury->currency ?? 'EGP' }}</small></h3>

                    <div class="text-muted small">
                        <i class="fas fa-history me-1"></i> {{ $treasury->transactions_count }} {{ __('Transactions') }}
                    </div>

                    <div class="mt-3 d-grid">
                        <a href="{{ route('accounting.treasuries.show', $treasury) }}"
                            class="btn btn-outline-light btn-sm">{{ __('Manage') }}</a>
                    </div>
                </div>
            </div>

            <!-- Edit Modal -->
            <div class="modal fade" id="editTreasury{{ $treasury->id }}" tabindex="-1">
                <div class="modal-dialog">
                    <form action="{{ route('accounting.treasuries.update', $treasury) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-content bg-dark">
                            <div class="modal-header border-secondary">
                                <h5 class="modal-title">{{ __('Edit Treasury') }}</h5>
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Name') }}</label>
                                    <input type="text" name="name" class="form-control" value="{{ $treasury->name }}"
                                        required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Type') }}</label>
                                    <select name="type" class="form-select" required>
                                        <option value="cash" {{ $treasury->type == 'cash' ? 'selected' : '' }}>
                                            {{ __('Cash Safe (خزنة نقدية)') }}
                                        </option>
                                        <option value="bank" {{ $treasury->type == 'bank' ? 'selected' : '' }}>
                                            {{ __('Bank Account (حساب بنكي)') }}
                                        </option>
                                        <option value="wallet" {{ $treasury->type == 'wallet' ? 'selected' : '' }}>
                                            {{ __('Digital Wallet (محفظة رقمية)') }}
                                        </option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Currency') }}</label>
                                    <select name="currency_id" class="form-select">
                                        @foreach($currencies as $currency)
                                            <option value="{{ $currency->id }}" {{ $treasury->currency_id == $currency->id ? 'selected' : '' }}>
                                                {{ $currency->code }} - {{ $currency->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer border-secondary">
                                <button type="button" class="btn btn-secondary"
                                    data-bs-dismiss="modal">{{ __('Close') }}</button>
                                <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @empty
        <div class="col-12 text-center py-5">
            <i class="fas fa-vault fa-3x text-muted mb-3"></i>
            <h3>{{ __('No treasuries found') }}</h3>
            <p class="text-muted">{{ __('Create a safe or bank account to start tracking finances.') }}</p>
        </div>
    @endforelse
</div>

<!-- Create Modal -->
<div class="modal fade" id="createTreasuryModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="{{ route('accounting.treasuries.store') }}" method="POST">
            @csrf
            <div class="modal-content bg-dark">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title">{{ __('Create New Treasury') }}</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('Name') }} <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control"
                            placeholder="{{ __('e.g. Main Safe, CIB Bank') }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Type') }} <span class="text-danger">*</span></label>
                        <select name="type" class="form-select" required>
                            <option value="cash">{{ __('Cash Safe (خزنة نقدية)') }}</option>
                            <option value="bank">{{ __('Bank Account (حساب بنكي)') }}</option>
                            <option value="wallet">{{ __('Digital Wallet (محفظة رقمية)') }}</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Currency') }}</label>
                        <select name="currency_id" class="form-select">
                            @foreach($currencies as $currency)
                                <option value="{{ $currency->id }}" {{ $currency->is_base ? 'selected' : '' }}>
                                    {{ $currency->code }} - {{ $currency->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Opening Balance (Raseed Eftitahy)') }}</label>
                        <input type="number" step="0.01" name="balance" class="form-control" value="0">
                        <div class="form-text text-muted">{{ __('Initial amount in this treasury.') }}</div>
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Create Treasury') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>
</div>

<!-- Transfer Modal -->
<div class="modal fade" id="transferModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="{{ route('accounting.treasuries.transfer') }}" method="POST">
            @csrf
            <div class="modal-content bg-dark">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title">{{ __('Transfer Funds') }}</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('From (Source)') }} <span class="text-danger">*</span></label>
                        <select name="from_treasury_id" class="form-select" required>
                            @foreach($treasuries as $t)
                                <option value="{{ $t->id }}">{{ $t->name }} ({{ number_format($t->balance, 2) }})</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('To (Destination)') }} <span
                                class="text-danger">*</span></label>
                        <select name="to_treasury_id" class="form-select" required>
                            @foreach($treasuries as $t)
                                <option value="{{ $t->id }}">{{ $t->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Amount') }} <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="amount" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Date') }} <span class="text-danger">*</span></label>
                        <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Description') }}</label>
                        <input type="text" name="description" class="form-control"
                            placeholder="{{ __('Reason for transfer') }}">
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button type="submit" class="btn btn-warning">{{ __('Execute Transfer') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>